@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetIpsecServersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIpsecServers.
 * @property ids A list of Ipsec Server IDs.
 * @property ipsecServerName The name of the IPsec server.
 * @property nameRegex A regex string to filter results by Ipsec Server name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property vpnGatewayId The ID of the VPN gateway.
 */
public data class GetIpsecServersPlainArgs(
    public val ids: List<String>? = null,
    public val ipsecServerName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val vpnGatewayId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetIpsecServersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetIpsecServersPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetIpsecServersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipsecServerName(ipsecServerName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpsecServersPlainArgs].
 */
@PulumiTagMarker
public class GetIpsecServersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var ipsecServerName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var vpnGatewayId: String? = null

    /**
     * @param value A list of Ipsec Server IDs.
     */
    @JvmName("rvqejbtixelcvkan")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Ipsec Server IDs.
     */
    @JvmName("pkyelemmjmfcnvce")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of the IPsec server.
     */
    @JvmName("kpdcymrywujxmtld")
    public suspend fun ipsecServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipsecServerName = mapped
    }

    /**
     * @param value A regex string to filter results by Ipsec Server name.
     */
    @JvmName("aywsiwjiowbntneg")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dvaskjxjfnesxlgk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the VPN gateway.
     */
    @JvmName("fbkmgnjjtrjmeguy")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpnGatewayId = mapped
    }

    internal fun build(): GetIpsecServersPlainArgs = GetIpsecServersPlainArgs(
        ids = ids,
        ipsecServerName = ipsecServerName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        vpnGatewayId = vpnGatewayId,
    )
}
