@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetIpv4GatewaysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIpv4Gateways.
 * @property ids A list of Ipv4 Gateway IDs.
 * @property ipv4GatewayName The name of the IPv4 gateway.
 * @property nameRegex A regex string to filter results by Ipv4 Gateway name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values: `Creating`, `Created`, `Deleting`, `Pending`, `Deleted`.
 * @property vpcId The ID of the VPC associated with the IPv4 Gateway.
 */
public data class GetIpv4GatewaysPlainArgs(
    public val ids: List<String>? = null,
    public val ipv4GatewayName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetIpv4GatewaysPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetIpv4GatewaysPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetIpv4GatewaysPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv4GatewayName(ipv4GatewayName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpv4GatewaysPlainArgs].
 */
@PulumiTagMarker
public class GetIpv4GatewaysPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var ipv4GatewayName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var vpcId: String? = null

    /**
     * @param value A list of Ipv4 Gateway IDs.
     */
    @JvmName("ehclvrkehkywacca")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Ipv4 Gateway IDs.
     */
    @JvmName("egsvoeawhbegbhrw")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of the IPv4 gateway.
     */
    @JvmName("rykklmmkcjymkukg")
    public suspend fun ipv4GatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipv4GatewayName = mapped
    }

    /**
     * @param value A regex string to filter results by Ipv4 Gateway name.
     */
    @JvmName("yqtrnoddaehephan")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lnlgqocemfvxsapq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Creating`, `Created`, `Deleting`, `Pending`, `Deleted`.
     */
    @JvmName("tyiklthlmodxqycu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the VPC associated with the IPv4 Gateway.
     */
    @JvmName("khcidkuhfwcdnqju")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetIpv4GatewaysPlainArgs = GetIpv4GatewaysPlainArgs(
        ids = ids,
        ipv4GatewayName = ipv4GatewayName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        vpcId = vpcId,
    )
}
