@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetIpv6AddressesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIpv6Addresses.
 * @property associatedInstanceId The ID of the instance that is assigned the IPv6 address.
 * @property ids
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the IPv6 address. Valid values:`Pending` or `Available`.
 * - `Pending`: The IPv6 address is being configured.
 * - `Available`: The IPv6 address is available.
 * @property vpcId The ID of the VPC to which the IPv6 address belongs.
 * @property vswitchId The ID of the vSwitch to which the IPv6 address belongs.
 */
public data class GetIpv6AddressesPlainArgs(
    public val associatedInstanceId: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetIpv6AddressesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetIpv6AddressesPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetIpv6AddressesPlainArgs.builder()
            .associatedInstanceId(associatedInstanceId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 }))
            .vswitchId(vswitchId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpv6AddressesPlainArgs].
 */
@PulumiTagMarker
public class GetIpv6AddressesPlainArgsBuilder internal constructor() {
    private var associatedInstanceId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var vpcId: String? = null

    private var vswitchId: String? = null

    /**
     * @param value The ID of the instance that is assigned the IPv6 address.
     */
    @JvmName("rhamweamxprpfkyq")
    public suspend fun associatedInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.associatedInstanceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("enirdvmncrxgofrs")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("cnrwtgcvybmvbtbv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("njgnhppjvcbepgdo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the IPv6 address. Valid values:`Pending` or `Available`.
     * - `Pending`: The IPv6 address is being configured.
     * - `Available`: The IPv6 address is available.
     */
    @JvmName("piisqykqgmwvtsvg")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the VPC to which the IPv6 address belongs.
     */
    @JvmName("lhmycisjdfxilafi")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the vSwitch to which the IPv6 address belongs.
     */
    @JvmName("innvraembctjmawm")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchId = mapped
    }

    internal fun build(): GetIpv6AddressesPlainArgs = GetIpv6AddressesPlainArgs(
        associatedInstanceId = associatedInstanceId,
        ids = ids,
        outputFile = outputFile,
        status = status,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
