@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetIpv6EgressRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIpv6EgressRules.
 * @property ids A list of Ipv6 Egress Rule IDs.
 * @property instanceId The ID of the instance that is associated with the IPv6 address to which the egress-only rule is applied.
 * @property ipv6EgressRuleName The name of the resource.
 * @property ipv6GatewayId The ID of the IPv6 gateway.
 * @property nameRegex A regex string to filter results by Ipv6 Egress Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values: `Available`, `Deleting`, `Pending`.
 */
public data class GetIpv6EgressRulesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    public val ipv6EgressRuleName: String? = null,
    public val ipv6GatewayId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetIpv6EgressRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetIpv6EgressRulesPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetIpv6EgressRulesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .ipv6EgressRuleName(ipv6EgressRuleName?.let({ args0 -> args0 }))
            .ipv6GatewayId(ipv6GatewayId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpv6EgressRulesPlainArgs].
 */
@PulumiTagMarker
public class GetIpv6EgressRulesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var ipv6EgressRuleName: String? = null

    private var ipv6GatewayId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Ipv6 Egress Rule IDs.
     */
    @JvmName("ghonxhkhvykwfupe")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Ipv6 Egress Rule IDs.
     */
    @JvmName("fhtntaihuytysdkv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the instance that is associated with the IPv6 address to which the egress-only rule is applied.
     */
    @JvmName("ikarfyusbidjkjgo")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("ihcaahvirkqvyttx")
    public suspend fun ipv6EgressRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipv6EgressRuleName = mapped
    }

    /**
     * @param value The ID of the IPv6 gateway.
     */
    @JvmName("cludhhfukwiceraa")
    public suspend fun ipv6GatewayId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipv6GatewayId = mapped
    }

    /**
     * @param value A regex string to filter results by Ipv6 Egress Rule name.
     */
    @JvmName("sekvwdqcsamfphux")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("stsexlstejwrummg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Available`, `Deleting`, `Pending`.
     */
    @JvmName("vpibefmtsscggyot")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetIpv6EgressRulesPlainArgs = GetIpv6EgressRulesPlainArgs(
        ids = ids,
        instanceId = instanceId,
        ipv6EgressRuleName = ipv6EgressRuleName,
        ipv6GatewayId = ipv6GatewayId ?: throw PulumiNullFieldException("ipv6GatewayId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
