@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetIpv6GatewaysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIpv6Gateways.
 * @property ids A list of Ipv6 Gateway IDs.
 * @property ipv6GatewayName The name of the IPv6 gateway.
 * @property nameRegex A regex string to filter results by Ipv6 Gateway name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values: `Available`, `Deleting`, `Pending`.
 * @property vpcId The ID of the virtual private cloud (VPC) to which the IPv6 gateway belongs.
 */
public data class GetIpv6GatewaysPlainArgs(
    public val ids: List<String>? = null,
    public val ipv6GatewayName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetIpv6GatewaysPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetIpv6GatewaysPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetIpv6GatewaysPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6GatewayName(ipv6GatewayName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpv6GatewaysPlainArgs].
 */
@PulumiTagMarker
public class GetIpv6GatewaysPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var ipv6GatewayName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var vpcId: String? = null

    /**
     * @param value A list of Ipv6 Gateway IDs.
     */
    @JvmName("aknhipicajsfqaqn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Ipv6 Gateway IDs.
     */
    @JvmName("tgpukypvhxahsabk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of the IPv6 gateway.
     */
    @JvmName("gaxaycxcydwpqutf")
    public suspend fun ipv6GatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipv6GatewayName = mapped
    }

    /**
     * @param value A regex string to filter results by Ipv6 Gateway name.
     */
    @JvmName("nyqlquahrhyoapac")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("svecyieemjygsanq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Available`, `Deleting`, `Pending`.
     */
    @JvmName("oanrigpexbvfocdw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the virtual private cloud (VPC) to which the IPv6 gateway belongs.
     */
    @JvmName("hmsgcrdlyawwsovf")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetIpv6GatewaysPlainArgs = GetIpv6GatewaysPlainArgs(
        ids = ids,
        ipv6GatewayName = ipv6GatewayName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        vpcId = vpcId,
    )
}
