@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetIpv6InternetBandwidthsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIpv6InternetBandwidths.
 * @property ids A list of Ipv6 Internet Bandwidth IDs.
 * @property ipv6AddressId The ID of the IPv6 address.
 * @property ipv6InternetBandwidthId The ID of the Ipv6 Internet Bandwidth.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values: `Normal`, `FinancialLocked` and `SecurityLocked`.
 */
public data class GetIpv6InternetBandwidthsPlainArgs(
    public val ids: List<String>? = null,
    public val ipv6AddressId: String? = null,
    public val ipv6InternetBandwidthId: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetIpv6InternetBandwidthsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetIpv6InternetBandwidthsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetIpv6InternetBandwidthsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6AddressId(ipv6AddressId?.let({ args0 -> args0 }))
            .ipv6InternetBandwidthId(ipv6InternetBandwidthId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpv6InternetBandwidthsPlainArgs].
 */
@PulumiTagMarker
public class GetIpv6InternetBandwidthsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var ipv6AddressId: String? = null

    private var ipv6InternetBandwidthId: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Ipv6 Internet Bandwidth IDs.
     */
    @JvmName("nrnawmdmrjlothdb")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Ipv6 Internet Bandwidth IDs.
     */
    @JvmName("wahlnybmeocbfjre")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the IPv6 address.
     */
    @JvmName("yxedpbswijvhlnnk")
    public suspend fun ipv6AddressId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipv6AddressId = mapped
    }

    /**
     * @param value The ID of the Ipv6 Internet Bandwidth.
     */
    @JvmName("nikrakwtqibdxrla")
    public suspend fun ipv6InternetBandwidthId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipv6InternetBandwidthId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gauddwcrnhcwgqci")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Normal`, `FinancialLocked` and `SecurityLocked`.
     */
    @JvmName("eiyugiwllwqvexyd")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetIpv6InternetBandwidthsPlainArgs = GetIpv6InternetBandwidthsPlainArgs(
        ids = ids,
        ipv6AddressId = ipv6AddressId,
        ipv6InternetBandwidthId = ipv6InternetBandwidthId,
        outputFile = outputFile,
        status = status,
    )
}
