@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetNatGatewaysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNatGateways.
 * @property dryRun Specifies whether to only precheck the request.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of NAT gateways IDs.
 * @property nameRegex A regex string to filter nat gateways by name.
 * @property natGatewayName The name of NAT gateway.
 * @property natType The nat type of NAT gateway. Valid values `Enhanced` and `Normal`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property paymentType The payment type of NAT gateway. Valid values `PayAsYouGo` and `Subscription`.
 * @property resourceGroupId The resource group id of NAT gateway.
 * @property specification The specification of NAT gateway. Valid values `Middle`, `Large`, `Small` and `XLarge.1`. Default value is `Small`.
 * @property status The status of NAT gateway. Valid values `Available`, `Converting`, `Creating`, `Deleting` and `Modifying`.
 * @property tags The tags of NAT gateway.
 * @property vpcId The ID of the VPC.
 */
public data class GetNatGatewaysPlainArgs(
    public val dryRun: Boolean? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val natGatewayName: String? = null,
    public val natType: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val paymentType: String? = null,
    public val resourceGroupId: String? = null,
    public val specification: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetNatGatewaysPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetNatGatewaysPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetNatGatewaysPlainArgs.builder()
            .dryRun(dryRun?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .natGatewayName(natGatewayName?.let({ args0 -> args0 }))
            .natType(natType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .paymentType(paymentType?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .specification(specification?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNatGatewaysPlainArgs].
 */
@PulumiTagMarker
public class GetNatGatewaysPlainArgsBuilder internal constructor() {
    private var dryRun: Boolean? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var natGatewayName: String? = null

    private var natType: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var paymentType: String? = null

    private var resourceGroupId: String? = null

    private var specification: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    /**
     * @param value Specifies whether to only precheck the request.
     */
    @JvmName("wvybuspoyfjxtksl")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dryRun = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("edfolwghynvubyst")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of NAT gateways IDs.
     */
    @JvmName("nqotmblhaunphbhx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of NAT gateways IDs.
     */
    @JvmName("dfhaisccteptgbmh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter nat gateways by name.
     */
    @JvmName("rxkpgyrcogiedako")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The name of NAT gateway.
     */
    @JvmName("vlfjmopvvewoogej")
    public suspend fun natGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.natGatewayName = mapped
    }

    /**
     * @param value The nat type of NAT gateway. Valid values `Enhanced` and `Normal`.
     */
    @JvmName("qkpxpouwbenyrcwe")
    public suspend fun natType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.natType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bcjqpgideylkattv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ihudbgeqgbwqfyxm")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("ynxnwhajiqayyruh")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The payment type of NAT gateway. Valid values `PayAsYouGo` and `Subscription`.
     */
    @JvmName("fdaoenfyetdmklus")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.paymentType = mapped
    }

    /**
     * @param value The resource group id of NAT gateway.
     */
    @JvmName("uonkxgmuaefmwmpf")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The specification of NAT gateway. Valid values `Middle`, `Large`, `Small` and `XLarge.1`. Default value is `Small`.
     */
    @JvmName("fivxkqwvndljirji")
    public suspend fun specification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.specification = mapped
    }

    /**
     * @param value The status of NAT gateway. Valid values `Available`, `Converting`, `Creating`, `Deleting` and `Modifying`.
     */
    @JvmName("kfnfcdfjqlgnwaro")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The tags of NAT gateway.
     */
    @JvmName("talrqqfwwejlcsdt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values The tags of NAT gateway.
     */
    @JvmName("pfnymorptdslhcnt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("flrvccmujstpwtxl")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetNatGatewaysPlainArgs = GetNatGatewaysPlainArgs(
        dryRun = dryRun,
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        natGatewayName = natGatewayName,
        natType = natType,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        paymentType = paymentType,
        resourceGroupId = resourceGroupId,
        specification = specification,
        status = status,
        tags = tags,
        vpcId = vpcId,
    )
}
