@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetNatIpCidrsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNatIpCidrs.
 * @property ids A list of Nat Ip Cidr IDs.
 * @property nameRegex A regex string to filter results by Nat Ip Cidr name.
 * @property natGatewayId NAT IP ADDRESS range to the security group of the Kafka VPC NAT gateway instance ID.
 * @property natIpCidrNames The name of the CIDR block that you want to query. Support up to `20`.
 * @property natIpCidrs The NAT CIDR block to be created. Support up to `20`. The CIDR block must meet the following conditions: It must be `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`, or one of their subnets. The subnet mask must be `16` to `32` bits in lengths. To use a public CIDR block as the NAT CIDR block, the VPC to which the VPC NAT gateway belongs must be authorized to use public CIDR blocks. For more information, see [Create a VPC NAT gateway](https://www.alibabacloud.com/help/doc-detail/268230.htm).
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the NAT IP address. Valid values:`Available`.
 */
public data class GetNatIpCidrsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val natGatewayId: String,
    public val natIpCidrNames: List<String>? = null,
    public val natIpCidrs: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetNatIpCidrsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetNatIpCidrsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetNatIpCidrsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .natGatewayId(natGatewayId.let({ args0 -> args0 }))
            .natIpCidrNames(natIpCidrNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .natIpCidrs(natIpCidrs?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNatIpCidrsPlainArgs].
 */
@PulumiTagMarker
public class GetNatIpCidrsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var natGatewayId: String? = null

    private var natIpCidrNames: List<String>? = null

    private var natIpCidrs: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Nat Ip Cidr IDs.
     */
    @JvmName("uooqmnckpcmbqqvm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Nat Ip Cidr IDs.
     */
    @JvmName("utblkytpcdkhluea")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Nat Ip Cidr name.
     */
    @JvmName("uuusejwkkqtroqfh")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value NAT IP ADDRESS range to the security group of the Kafka VPC NAT gateway instance ID.
     */
    @JvmName("xgedfiesedwnbtqt")
    public suspend fun natGatewayId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.natGatewayId = mapped
    }

    /**
     * @param value The name of the CIDR block that you want to query. Support up to `20`.
     */
    @JvmName("qqwjldtvqyfsmpor")
    public suspend fun natIpCidrNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.natIpCidrNames = mapped
    }

    /**
     * @param values The name of the CIDR block that you want to query. Support up to `20`.
     */
    @JvmName("rlyantnlcdvxxwhg")
    public suspend fun natIpCidrNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.natIpCidrNames = mapped
    }

    /**
     * @param value The NAT CIDR block to be created. Support up to `20`. The CIDR block must meet the following conditions: It must be `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`, or one of their subnets. The subnet mask must be `16` to `32` bits in lengths. To use a public CIDR block as the NAT CIDR block, the VPC to which the VPC NAT gateway belongs must be authorized to use public CIDR blocks. For more information, see [Create a VPC NAT gateway](https://www.alibabacloud.com/help/doc-detail/268230.htm).
     */
    @JvmName("uagkepscvqwihfgu")
    public suspend fun natIpCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.natIpCidrs = mapped
    }

    /**
     * @param values The NAT CIDR block to be created. Support up to `20`. The CIDR block must meet the following conditions: It must be `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`, or one of their subnets. The subnet mask must be `16` to `32` bits in lengths. To use a public CIDR block as the NAT CIDR block, the VPC to which the VPC NAT gateway belongs must be authorized to use public CIDR blocks. For more information, see [Create a VPC NAT gateway](https://www.alibabacloud.com/help/doc-detail/268230.htm).
     */
    @JvmName("plswfxaqifjftlgu")
    public suspend fun natIpCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.natIpCidrs = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("itciqbklatupmnen")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the NAT IP address. Valid values:`Available`.
     */
    @JvmName("ijexgllljlvitknt")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetNatIpCidrsPlainArgs = GetNatIpCidrsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        natGatewayId = natGatewayId ?: throw PulumiNullFieldException("natGatewayId"),
        natIpCidrNames = natIpCidrNames,
        natIpCidrs = natIpCidrs,
        outputFile = outputFile,
        status = status,
    )
}
