@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetNatIpsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNatIps.
 * @property ids A list of Nat Ip IDs.
 * @property nameRegex A regex string to filter results by Nat Ip name.
 * @property natGatewayId The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
 * @property natIpCidr NAT IP ADDRESS of the address segment.
 * @property natIpIds
 * @property natIpNames NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the NAT IP address. Valid values: `Available`, `Deleting` and `Creating`.
 */
public data class GetNatIpsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val natGatewayId: String,
    public val natIpCidr: String? = null,
    public val natIpIds: List<String>? = null,
    public val natIpNames: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetNatIpsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetNatIpsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetNatIpsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .natGatewayId(natGatewayId.let({ args0 -> args0 }))
            .natIpCidr(natIpCidr?.let({ args0 -> args0 }))
            .natIpIds(natIpIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .natIpNames(natIpNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNatIpsPlainArgs].
 */
@PulumiTagMarker
public class GetNatIpsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var natGatewayId: String? = null

    private var natIpCidr: String? = null

    private var natIpIds: List<String>? = null

    private var natIpNames: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Nat Ip IDs.
     */
    @JvmName("wnmvkdlncqbjlrlk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Nat Ip IDs.
     */
    @JvmName("kfywcedovmjqqccm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Nat Ip name.
     */
    @JvmName("fstbsjiyliryljhi")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
     */
    @JvmName("flsblyvyyqywlhip")
    public suspend fun natGatewayId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.natGatewayId = mapped
    }

    /**
     * @param value NAT IP ADDRESS of the address segment.
     */
    @JvmName("rdoeyxicrqdaimwe")
    public suspend fun natIpCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.natIpCidr = mapped
    }

    /**
     * @param value
     */
    @JvmName("gufimlqbbdbakcpc")
    public suspend fun natIpIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.natIpIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("vlxxuyjtajjadkie")
    public suspend fun natIpIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.natIpIds = mapped
    }

    /**
     * @param value NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
     */
    @JvmName("pwpdyefliyxrgsol")
    public suspend fun natIpNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.natIpNames = mapped
    }

    /**
     * @param values NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
     */
    @JvmName("qtckeaqmwvwnafng")
    public suspend fun natIpNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.natIpNames = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("aoasnmdwpqwgwwxp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the NAT IP address. Valid values: `Available`, `Deleting` and `Creating`.
     */
    @JvmName("qrludnpvtxppptby")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetNatIpsPlainArgs = GetNatIpsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        natGatewayId = natGatewayId ?: throw PulumiNullFieldException("natGatewayId"),
        natIpCidr = natIpCidr,
        natIpIds = natIpIds,
        natIpNames = natIpNames,
        outputFile = outputFile,
        status = status,
    )
}
