@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetNetworkAclsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNetworkAcls.
 * @property ids A list of Network Acl ID.
 * @property nameRegex A regex string to filter results by Network Acl name.
 * @property networkAclName The name of the network ACL.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceId The ID of the associated resource.
 * @property resourceType The type of the associated resource. Valid values `VSwitch`. `resource_type` and `resource_id` need to be specified at the same time to take effect.
 * @property status The state of the network ACL. Valid values: `Available` and `Modifying`.
 * @property vpcId The ID of the associated VPC.
 */
public data class GetNetworkAclsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val networkAclName: String? = null,
    public val outputFile: String? = null,
    public val resourceId: String? = null,
    public val resourceType: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetNetworkAclsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetNetworkAclsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetNetworkAclsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .networkAclName(networkAclName?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceId(resourceId?.let({ args0 -> args0 }))
            .resourceType(resourceType?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkAclsPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkAclsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var networkAclName: String? = null

    private var outputFile: String? = null

    private var resourceId: String? = null

    private var resourceType: String? = null

    private var status: String? = null

    private var vpcId: String? = null

    /**
     * @param value A list of Network Acl ID.
     */
    @JvmName("mhkqpwqcdklartvv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Network Acl ID.
     */
    @JvmName("oumsmjkbqkbtuega")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Network Acl name.
     */
    @JvmName("cibqplaupuhcbfki")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The name of the network ACL.
     */
    @JvmName("koyjkvpmflxwwnoq")
    public suspend fun networkAclName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkAclName = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("unmckbwqovytgyfp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the associated resource.
     */
    @JvmName("vcvlukgutlvmjprf")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    /**
     * @param value The type of the associated resource. Valid values `VSwitch`. `resource_type` and `resource_id` need to be specified at the same time to take effect.
     */
    @JvmName("llgrmecocoehlngt")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    /**
     * @param value The state of the network ACL. Valid values: `Available` and `Modifying`.
     */
    @JvmName("hfogwalvexvtniog")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the associated VPC.
     */
    @JvmName("ialrfarhkpwxugil")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetNetworkAclsPlainArgs = GetNetworkAclsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        networkAclName = networkAclName,
        outputFile = outputFile,
        resourceId = resourceId,
        resourceType = resourceType,
        status = status,
        vpcId = vpcId,
    )
}
