@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetNetworksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNetworks.
 * @property cidrBlock Filter results by a specific CIDR block. For example: "172.16.0.0/12".
 * @property dhcpOptionsSetId The ID of dhcp options set.
 * @property dryRun Indicates whether to check this request only. Valid values: `true` and `false`.
 * @property enableDetails Default to `true`. Set it to true can output the `route_table_id`.
 * @property ids A list of VPC IDs.
 * @property isDefault Indicate whether the VPC is the default one in the specified region.
 * @property nameRegex A regex string to filter VPCs by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId The Id of resource group which VPC belongs.
 * @property status Filter results by a specific status. Valid value are `Pending` and `Available`.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcName The name of the VPC.
 * @property vpcOwnerId The owner ID of VPC.
 * @property vswitchId Filter results by the specified vSwitch.
 */
public data class GetNetworksPlainArgs(
    public val cidrBlock: String? = null,
    public val dhcpOptionsSetId: String? = null,
    public val dryRun: Boolean? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val isDefault: Boolean? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcName: String? = null,
    public val vpcOwnerId: Int? = null,
    public val vswitchId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetNetworksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetNetworksPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetNetworksPlainArgs.builder()
            .cidrBlock(cidrBlock?.let({ args0 -> args0 }))
            .dhcpOptionsSetId(dhcpOptionsSetId?.let({ args0 -> args0 }))
            .dryRun(dryRun?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .isDefault(isDefault?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcName(vpcName?.let({ args0 -> args0 }))
            .vpcOwnerId(vpcOwnerId?.let({ args0 -> args0 }))
            .vswitchId(vswitchId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworksPlainArgs].
 */
@PulumiTagMarker
public class GetNetworksPlainArgsBuilder internal constructor() {
    private var cidrBlock: String? = null

    private var dhcpOptionsSetId: String? = null

    private var dryRun: Boolean? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var isDefault: Boolean? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var vpcName: String? = null

    private var vpcOwnerId: Int? = null

    private var vswitchId: String? = null

    /**
     * @param value Filter results by a specific CIDR block. For example: "172.16.0.0/12".
     */
    @JvmName("uswuxocqtuhawtcx")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cidrBlock = mapped
    }

    /**
     * @param value The ID of dhcp options set.
     */
    @JvmName("fqfahcducqomjkwe")
    public suspend fun dhcpOptionsSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dhcpOptionsSetId = mapped
    }

    /**
     * @param value Indicates whether to check this request only. Valid values: `true` and `false`.
     */
    @JvmName("okosppoxojatsvjw")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dryRun = mapped
    }

    /**
     * @param value Default to `true`. Set it to true can output the `route_table_id`.
     */
    @JvmName("xbmffhvhvmkipjni")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of VPC IDs.
     */
    @JvmName("ttgcqbkjjdlkawxu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of VPC IDs.
     */
    @JvmName("olrguoxabglehlbf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Indicate whether the VPC is the default one in the specified region.
     */
    @JvmName("oidnbvpsrjhdcwds")
    public suspend fun isDefault(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isDefault = mapped
    }

    /**
     * @param value A regex string to filter VPCs by name.
     */
    @JvmName("adelmuijnwioofne")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hfgkgmcbibcwpolh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("eyorgrkyvkggnhgf")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("uyqipvlkgiurkfae")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The Id of resource group which VPC belongs.
     */
    @JvmName("qetkypcmyvmbnfwq")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Filter results by a specific status. Valid value are `Pending` and `Available`.
     */
    @JvmName("vdmwfgjvqnkgvovm")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("kcbsrpmeakdvreyu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("flaabqrgsrulokcu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The name of the VPC.
     */
    @JvmName("utpuospbuctaotcr")
    public suspend fun vpcName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcName = mapped
    }

    /**
     * @param value The owner ID of VPC.
     */
    @JvmName("lsnlrtdxfobalxgt")
    public suspend fun vpcOwnerId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcOwnerId = mapped
    }

    /**
     * @param value Filter results by the specified vSwitch.
     */
    @JvmName("xchjewbubpmxiohh")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchId = mapped
    }

    internal fun build(): GetNetworksPlainArgs = GetNetworksPlainArgs(
        cidrBlock = cidrBlock,
        dhcpOptionsSetId = dhcpOptionsSetId,
        dryRun = dryRun,
        enableDetails = enableDetails,
        ids = ids,
        isDefault = isDefault,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        resourceGroupId = resourceGroupId,
        status = status,
        tags = tags,
        vpcName = vpcName,
        vpcOwnerId = vpcOwnerId,
        vswitchId = vswitchId,
    )
}
