@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetPbrRouteEntriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPbrRouteEntries.
 * @property ids A list of VPN Pbr Route Entries IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property vpnGatewayId The ID of the VPN gateway.
 */
public data class GetPbrRouteEntriesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val vpnGatewayId: String,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetPbrRouteEntriesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetPbrRouteEntriesPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetPbrRouteEntriesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPbrRouteEntriesPlainArgs].
 */
@PulumiTagMarker
public class GetPbrRouteEntriesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var vpnGatewayId: String? = null

    /**
     * @param value A list of VPN Pbr Route Entries IDs.
     */
    @JvmName("xahovfefexivynkr")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of VPN Pbr Route Entries IDs.
     */
    @JvmName("emxjqtteeveaoxwc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("piqksyhackqoqdvv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the VPN gateway.
     */
    @JvmName("granoytaemhuljum")
    public suspend fun vpnGatewayId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vpnGatewayId = mapped
    }

    internal fun build(): GetPbrRouteEntriesPlainArgs = GetPbrRouteEntriesPlainArgs(
        ids = ids,
        outputFile = outputFile,
        vpnGatewayId = vpnGatewayId ?: throw PulumiNullFieldException("vpnGatewayId"),
    )
}
