@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetPeerConnectionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPeerConnections.
 * @property ids A list of PeerConnection IDs.
 * @property nameRegex A regex string to filter results by PeerConnection name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property peerConnectionName The name of the resource.
 * @property status The status of the resource. Valid values: `Accepting`, `Activated`, `Creating`, `Deleted`, `Deleting`, `Expired`, `Rejected`, `Updating`.
 * @property vpcId The ID of the requester VPC.
 */
public data class GetPeerConnectionsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val peerConnectionName: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetPeerConnectionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetPeerConnectionsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetPeerConnectionsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .peerConnectionName(peerConnectionName?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPeerConnectionsPlainArgs].
 */
@PulumiTagMarker
public class GetPeerConnectionsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var peerConnectionName: String? = null

    private var status: String? = null

    private var vpcId: String? = null

    /**
     * @param value A list of PeerConnection IDs.
     */
    @JvmName("nstcsjwewicsoacq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of PeerConnection IDs.
     */
    @JvmName("inddtanejhwefaer")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by PeerConnection name.
     */
    @JvmName("piomcmmedsghwpec")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("mdbnvvnmpvprhjfa")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("hfgnquyciqvuebtn")
    public suspend fun peerConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.peerConnectionName = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Accepting`, `Activated`, `Creating`, `Deleted`, `Deleting`, `Expired`, `Rejected`, `Updating`.
     */
    @JvmName("wseltncncnuaablw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the requester VPC.
     */
    @JvmName("rlcexipiwhtcrwrc")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetPeerConnectionsPlainArgs = GetPeerConnectionsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        peerConnectionName = peerConnectionName,
        status = status,
        vpcId = vpcId,
    )
}
