@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetPrefixListsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPrefixLists.
 * @property enableDetails Default to `true`. Set it to `false` can hide the `entrys` to output.
 * @property ids A list of Prefix List IDs.
 * @property nameRegex A regex string to filter results by Prefix List name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property prefixListName The name of the prefix list.
 */
public data class GetPrefixListsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val prefixListName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetPrefixListsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetPrefixListsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetPrefixListsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .prefixListName(prefixListName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrefixListsPlainArgs].
 */
@PulumiTagMarker
public class GetPrefixListsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var prefixListName: String? = null

    /**
     * @param value Default to `true`. Set it to `false` can hide the `entrys` to output.
     */
    @JvmName("hmonbbfamdiajoih")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Prefix List IDs.
     */
    @JvmName("toeyfvuvrsftsgdt")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Prefix List IDs.
     */
    @JvmName("gxpvstlmpuxkntxu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Prefix List name.
     */
    @JvmName("pgqfwdnhyhecuntu")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("cvxiqjasxqyeonag")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the prefix list.
     */
    @JvmName("omdajtpukubhkbqc")
    public suspend fun prefixListName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.prefixListName = mapped
    }

    internal fun build(): GetPrefixListsPlainArgs = GetPrefixListsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        prefixListName = prefixListName,
    )
}
