@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetPublicIpAddressPoolCidrBlocksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPublicIpAddressPoolCidrBlocks.
 * @property cidrBlock The CIDR block.
 * @property ids A list of Vpc Public Ip Address Pool Cidr Block IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property publicIpAddressPoolId The ID of the Vpc Public IP address pool.
 * @property status The status of the CIDR block in the Vpc Public IP address pool. Valid values: `Created`, `Modifying`, `Deleting`.
 */
public data class GetPublicIpAddressPoolCidrBlocksPlainArgs(
    public val cidrBlock: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val publicIpAddressPoolId: String,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetPublicIpAddressPoolCidrBlocksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetPublicIpAddressPoolCidrBlocksPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetPublicIpAddressPoolCidrBlocksPlainArgs.builder()
            .cidrBlock(cidrBlock?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .publicIpAddressPoolId(publicIpAddressPoolId.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPublicIpAddressPoolCidrBlocksPlainArgs].
 */
@PulumiTagMarker
public class GetPublicIpAddressPoolCidrBlocksPlainArgsBuilder internal constructor() {
    private var cidrBlock: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var publicIpAddressPoolId: String? = null

    private var status: String? = null

    /**
     * @param value The CIDR block.
     */
    @JvmName("cqijaofocjqsgryk")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cidrBlock = mapped
    }

    /**
     * @param value A list of Vpc Public Ip Address Pool Cidr Block IDs.
     */
    @JvmName("yguqtpdmakqpatds")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vpc Public Ip Address Pool Cidr Block IDs.
     */
    @JvmName("qiodkmdqoxthxend")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ncmqqowftdntdeab")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the Vpc Public IP address pool.
     */
    @JvmName("moofjipphjimdonh")
    public suspend fun publicIpAddressPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publicIpAddressPoolId = mapped
    }

    /**
     * @param value The status of the CIDR block in the Vpc Public IP address pool. Valid values: `Created`, `Modifying`, `Deleting`.
     */
    @JvmName("rnjyfgdjpdsnemac")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetPublicIpAddressPoolCidrBlocksPlainArgs =
        GetPublicIpAddressPoolCidrBlocksPlainArgs(
            cidrBlock = cidrBlock,
            ids = ids,
            outputFile = outputFile,
            publicIpAddressPoolId = publicIpAddressPoolId ?: throw
                PulumiNullFieldException("publicIpAddressPoolId"),
            status = status,
        )
}
