@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetPublicIpAddressPoolsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPublicIpAddressPools.
 * @property ids A list of Vpc Public Ip Address Pool IDs.
 * @property isp The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`.
 * @property nameRegex A regex string to filter results by Vpc Public Ip Address Pool name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property publicIpAddressPoolIds The IDs of the Vpc Public IP address pools.
 * @property publicIpAddressPoolName The name of the VPC Public IP address pool.
 * @property status The status of the Vpc Public Ip Address Pool. Valid values: `Created`, `Deleting`, `Modifying`.
 */
public data class GetPublicIpAddressPoolsPlainArgs(
    public val ids: List<String>? = null,
    public val isp: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val publicIpAddressPoolIds: List<String>? = null,
    public val publicIpAddressPoolName: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetPublicIpAddressPoolsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetPublicIpAddressPoolsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetPublicIpAddressPoolsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .isp(isp?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .publicIpAddressPoolIds(publicIpAddressPoolIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .publicIpAddressPoolName(publicIpAddressPoolName?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPublicIpAddressPoolsPlainArgs].
 */
@PulumiTagMarker
public class GetPublicIpAddressPoolsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var isp: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var publicIpAddressPoolIds: List<String>? = null

    private var publicIpAddressPoolName: String? = null

    private var status: String? = null

    /**
     * @param value A list of Vpc Public Ip Address Pool IDs.
     */
    @JvmName("mnyvxtojgjnflftd")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vpc Public Ip Address Pool IDs.
     */
    @JvmName("vedamguhwdrgdyse")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`.
     */
    @JvmName("lgcqkwvgbvsojtpr")
    public suspend fun isp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isp = mapped
    }

    /**
     * @param value A regex string to filter results by Vpc Public Ip Address Pool name.
     */
    @JvmName("stbyiasaxholwgly")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wniofxbrobojylqb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The IDs of the Vpc Public IP address pools.
     */
    @JvmName("gytmhmygegcltxyj")
    public suspend fun publicIpAddressPoolIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.publicIpAddressPoolIds = mapped
    }

    /**
     * @param values The IDs of the Vpc Public IP address pools.
     */
    @JvmName("endcgldegdsmpkps")
    public suspend fun publicIpAddressPoolIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publicIpAddressPoolIds = mapped
    }

    /**
     * @param value The name of the VPC Public IP address pool.
     */
    @JvmName("bwlmldbxrtfpbsjj")
    public suspend fun publicIpAddressPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.publicIpAddressPoolName = mapped
    }

    /**
     * @param value The status of the Vpc Public Ip Address Pool. Valid values: `Created`, `Deleting`, `Modifying`.
     */
    @JvmName("jipkgjrhywkcrlxn")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetPublicIpAddressPoolsPlainArgs = GetPublicIpAddressPoolsPlainArgs(
        ids = ids,
        isp = isp,
        nameRegex = nameRegex,
        outputFile = outputFile,
        publicIpAddressPoolIds = publicIpAddressPoolIds,
        publicIpAddressPoolName = publicIpAddressPoolName,
        status = status,
    )
}
