@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetRouteEntriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteEntries.
 * @property cidrBlock The destination CIDR block of the route entry.
 * @property instanceId The instance ID of the next hop.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property routeTableId The ID of the router table to which the route entry belongs.
 * @property type The type of the route entry.
 */
public data class GetRouteEntriesPlainArgs(
    public val cidrBlock: String? = null,
    public val instanceId: String? = null,
    public val outputFile: String? = null,
    public val routeTableId: String,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetRouteEntriesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetRouteEntriesPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetRouteEntriesPlainArgs.builder()
            .cidrBlock(cidrBlock?.let({ args0 -> args0 }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .routeTableId(routeTableId.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteEntriesPlainArgs].
 */
@PulumiTagMarker
public class GetRouteEntriesPlainArgsBuilder internal constructor() {
    private var cidrBlock: String? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    private var routeTableId: String? = null

    private var type: String? = null

    /**
     * @param value The destination CIDR block of the route entry.
     */
    @JvmName("rgioxkltuqjdswxp")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cidrBlock = mapped
    }

    /**
     * @param value The instance ID of the next hop.
     */
    @JvmName("xvmekxidfjuyemac")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nrwjbchcuhjkofqv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the router table to which the route entry belongs.
     */
    @JvmName("resexnandfqlrkxr")
    public suspend fun routeTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routeTableId = mapped
    }

    /**
     * @param value The type of the route entry.
     */
    @JvmName("tsxridqlntpmckhq")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetRouteEntriesPlainArgs = GetRouteEntriesPlainArgs(
        cidrBlock = cidrBlock,
        instanceId = instanceId,
        outputFile = outputFile,
        routeTableId = routeTableId ?: throw PulumiNullFieldException("routeTableId"),
        type = type,
    )
}
