@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetRouteTablesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteTables.
 * @property ids A list of Route Tables IDs.
 * @property nameRegex A regex string to filter route tables by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId The Id of resource group which route tables belongs.
 * @property routeTableName The route table name.
 * @property routerId The router ID.
 * @property routerType The route type of route table. Valid values: `VRouter` and `VBR`.
 * @property status The status of resource. Valid values: `Available` and `Pending`.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId Vpc id of the route table.
 */
public data class GetRouteTablesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val routeTableName: String? = null,
    public val routerId: String? = null,
    public val routerType: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetRouteTablesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetRouteTablesPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetRouteTablesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .routeTableName(routeTableName?.let({ args0 -> args0 }))
            .routerId(routerId?.let({ args0 -> args0 }))
            .routerType(routerType?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteTablesPlainArgs].
 */
@PulumiTagMarker
public class GetRouteTablesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var resourceGroupId: String? = null

    private var routeTableName: String? = null

    private var routerId: String? = null

    private var routerType: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    /**
     * @param value A list of Route Tables IDs.
     */
    @JvmName("gwywquisctdsvcbk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Route Tables IDs.
     */
    @JvmName("ohbpdtjdiorweanu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter route tables by name.
     */
    @JvmName("lprobwvkskripopk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kxjnskmbydccwtpg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("lpjffklhkdapbxdg")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("jxbjnraudokinwck")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The Id of resource group which route tables belongs.
     */
    @JvmName("makhqlkcuywqfojr")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The route table name.
     */
    @JvmName("kqnfvfmehevxlyfi")
    public suspend fun routeTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routeTableName = mapped
    }

    /**
     * @param value The router ID.
     */
    @JvmName("ivrvbthdvbtsruux")
    public suspend fun routerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routerId = mapped
    }

    /**
     * @param value The route type of route table. Valid values: `VRouter` and `VBR`.
     */
    @JvmName("alqrhbnilmspijsm")
    public suspend fun routerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routerType = mapped
    }

    /**
     * @param value The status of resource. Valid values: `Available` and `Pending`.
     */
    @JvmName("eajwkrbrfxrnjbnl")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("dksssmpplxleefij")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("veevuknguoekmgdx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Vpc id of the route table.
     */
    @JvmName("kivrarpjpuwtsmrb")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetRouteTablesPlainArgs = GetRouteTablesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        resourceGroupId = resourceGroupId,
        routeTableName = routeTableName,
        routerId = routerId,
        routerType = routerType,
        status = status,
        tags = tags,
        vpcId = vpcId,
    )
}
