@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetRouterInterfacesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouterInterfaces.
 * @property ids A list of router interface IDs.
 * @property nameRegex A regex string used to filter by router interface name.
 * @property oppositeInterfaceId ID of the peer router interface.
 * @property oppositeInterfaceOwnerId Account ID of the owner of the peer router interface.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property role Role of the router interface. Valid values are `InitiatingSide` (connection initiator) and
 * `AcceptingSide` (connection receiver). The value of this parameter must be `InitiatingSide` if the `router_type` is set to `VBR`.
 * @property routerId ID of the VRouter located in the local region.
 * @property routerType Router type in the local region. Valid values are `VRouter` and `VBR` (physical connection).
 * @property specification Specification of the link, such as `Small.1` (10Mb), `Middle.1` (100Mb), `Large.2` (2Gb), ...etc.
 * @property status Expected status. Valid values are `Active`, `Inactive` and `Idle`.
 */
public data class GetRouterInterfacesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val oppositeInterfaceId: String? = null,
    public val oppositeInterfaceOwnerId: String? = null,
    public val outputFile: String? = null,
    public val role: String? = null,
    public val routerId: String? = null,
    public val routerType: String? = null,
    public val specification: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetRouterInterfacesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetRouterInterfacesPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetRouterInterfacesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .oppositeInterfaceId(oppositeInterfaceId?.let({ args0 -> args0 }))
            .oppositeInterfaceOwnerId(oppositeInterfaceOwnerId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .role(role?.let({ args0 -> args0 }))
            .routerId(routerId?.let({ args0 -> args0 }))
            .routerType(routerType?.let({ args0 -> args0 }))
            .specification(specification?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouterInterfacesPlainArgs].
 */
@PulumiTagMarker
public class GetRouterInterfacesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var oppositeInterfaceId: String? = null

    private var oppositeInterfaceOwnerId: String? = null

    private var outputFile: String? = null

    private var role: String? = null

    private var routerId: String? = null

    private var routerType: String? = null

    private var specification: String? = null

    private var status: String? = null

    /**
     * @param value A list of router interface IDs.
     */
    @JvmName("foadoorcagsdhmpx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of router interface IDs.
     */
    @JvmName("ghkrcsfpigbuwxmi")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string used to filter by router interface name.
     */
    @JvmName("xhwbulmgtedixacf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value ID of the peer router interface.
     */
    @JvmName("vibemlqyrndmrbgc")
    public suspend fun oppositeInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.oppositeInterfaceId = mapped
    }

    /**
     * @param value Account ID of the owner of the peer router interface.
     */
    @JvmName("wwbsqjynergwpsnt")
    public suspend fun oppositeInterfaceOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.oppositeInterfaceOwnerId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jokhtnlnuwaleyud")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Role of the router interface. Valid values are `InitiatingSide` (connection initiator) and
     * `AcceptingSide` (connection receiver). The value of this parameter must be `InitiatingSide` if the `router_type` is set to `VBR`.
     */
    @JvmName("bkspwoqfvlnctoiu")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.role = mapped
    }

    /**
     * @param value ID of the VRouter located in the local region.
     */
    @JvmName("ousdhixkcepujsnr")
    public suspend fun routerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routerId = mapped
    }

    /**
     * @param value Router type in the local region. Valid values are `VRouter` and `VBR` (physical connection).
     */
    @JvmName("cmhwohiaweirqpma")
    public suspend fun routerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routerType = mapped
    }

    /**
     * @param value Specification of the link, such as `Small.1` (10Mb), `Middle.1` (100Mb), `Large.2` (2Gb), ...etc.
     */
    @JvmName("atciqihlajiddbrj")
    public suspend fun specification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.specification = mapped
    }

    /**
     * @param value Expected status. Valid values are `Active`, `Inactive` and `Idle`.
     */
    @JvmName("gcaxucnoulfevvll")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetRouterInterfacesPlainArgs = GetRouterInterfacesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        oppositeInterfaceId = oppositeInterfaceId,
        oppositeInterfaceOwnerId = oppositeInterfaceOwnerId,
        outputFile = outputFile,
        role = role,
        routerId = routerId,
        routerType = routerType,
        specification = specification,
        status = status,
    )
}
