@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetSnatEntriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSnatEntries.
 * @property ids A list of Snat Entries IDs.
 * @property nameRegex A regex string to filter results by the resource name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property snatEntryName The name of snat entry.
 * @property snatIp The public IP of the Snat Entry.
 * @property snatTableId The ID of the Snat table.
 * @property sourceCidr The source CIDR block of the Snat Entry.
 * @property sourceVswitchId The source vswitch ID.
 * @property status The status of the Snat Entry. Valid values: `Available`, `Deleting` and `Pending`.
 */
public data class GetSnatEntriesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val snatEntryName: String? = null,
    public val snatIp: String? = null,
    public val snatTableId: String,
    public val sourceCidr: String? = null,
    public val sourceVswitchId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetSnatEntriesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetSnatEntriesPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetSnatEntriesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .snatEntryName(snatEntryName?.let({ args0 -> args0 }))
            .snatIp(snatIp?.let({ args0 -> args0 }))
            .snatTableId(snatTableId.let({ args0 -> args0 }))
            .sourceCidr(sourceCidr?.let({ args0 -> args0 }))
            .sourceVswitchId(sourceVswitchId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSnatEntriesPlainArgs].
 */
@PulumiTagMarker
public class GetSnatEntriesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var snatEntryName: String? = null

    private var snatIp: String? = null

    private var snatTableId: String? = null

    private var sourceCidr: String? = null

    private var sourceVswitchId: String? = null

    private var status: String? = null

    /**
     * @param value A list of Snat Entries IDs.
     */
    @JvmName("ybmpaynyyavnbgmq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Snat Entries IDs.
     */
    @JvmName("nxvevlipmamqmmef")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by the resource name.
     */
    @JvmName("vupicwaexynqivoh")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bciriuakycvnbswo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of snat entry.
     */
    @JvmName("itkbffriekpiiadu")
    public suspend fun snatEntryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snatEntryName = mapped
    }

    /**
     * @param value The public IP of the Snat Entry.
     */
    @JvmName("cjllknttbckmknxh")
    public suspend fun snatIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snatIp = mapped
    }

    /**
     * @param value The ID of the Snat table.
     */
    @JvmName("cenisyosjamttsml")
    public suspend fun snatTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.snatTableId = mapped
    }

    /**
     * @param value The source CIDR block of the Snat Entry.
     */
    @JvmName("yuedpqypposfhiwy")
    public suspend fun sourceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceCidr = mapped
    }

    /**
     * @param value The source vswitch ID.
     */
    @JvmName("unvjuvmepiijxfdt")
    public suspend fun sourceVswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceVswitchId = mapped
    }

    /**
     * @param value The status of the Snat Entry. Valid values: `Available`, `Deleting` and `Pending`.
     */
    @JvmName("binkhwuftmjmwvud")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetSnatEntriesPlainArgs = GetSnatEntriesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        snatEntryName = snatEntryName,
        snatIp = snatIp,
        snatTableId = snatTableId ?: throw PulumiNullFieldException("snatTableId"),
        sourceCidr = sourceCidr,
        sourceVswitchId = sourceVswitchId,
        status = status,
    )
}
