@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetSslVpnClientCertsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSslVpnClientCerts.
 * @property ids IDs of the SSL-VPN client certificates.
 * @property nameRegex A regex string of SSL-VPN client certificate name.
 * @property outputFile Save the result to the file.
 * @property sslVpnServerId Use the SSL-VPN server ID as the search key.
 */
public data class GetSslVpnClientCertsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val sslVpnServerId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetSslVpnClientCertsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetSslVpnClientCertsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetSslVpnClientCertsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .sslVpnServerId(sslVpnServerId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSslVpnClientCertsPlainArgs].
 */
@PulumiTagMarker
public class GetSslVpnClientCertsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var sslVpnServerId: String? = null

    /**
     * @param value IDs of the SSL-VPN client certificates.
     */
    @JvmName("skcvykayuswoxmdu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values IDs of the SSL-VPN client certificates.
     */
    @JvmName("dbkaxqlvxpbkhsmg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string of SSL-VPN client certificate name.
     */
    @JvmName("vlsflsgnvpdblcah")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Save the result to the file.
     */
    @JvmName("ibccadmvctlxxaoi")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Use the SSL-VPN server ID as the search key.
     */
    @JvmName("dogvtjoxstkjxpvh")
    public suspend fun sslVpnServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sslVpnServerId = mapped
    }

    internal fun build(): GetSslVpnClientCertsPlainArgs = GetSslVpnClientCertsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        sslVpnServerId = sslVpnServerId,
    )
}
