@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetSslVpnServersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSslVpnServers.
 * @property ids IDs of the SSL-VPN servers.
 * @property nameRegex A regex string of SSL-VPN server name.
 * @property outputFile Save the result to the file.
 * @property vpnGatewayId Use the VPN gateway ID as the search key.
 */
public data class GetSslVpnServersPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val vpnGatewayId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetSslVpnServersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetSslVpnServersPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetSslVpnServersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSslVpnServersPlainArgs].
 */
@PulumiTagMarker
public class GetSslVpnServersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var vpnGatewayId: String? = null

    /**
     * @param value IDs of the SSL-VPN servers.
     */
    @JvmName("hfwvacadycnlnpgw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values IDs of the SSL-VPN servers.
     */
    @JvmName("pvcdswwjessymtfv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string of SSL-VPN server name.
     */
    @JvmName("ccrlrxtbstucrglh")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Save the result to the file.
     */
    @JvmName("xgxafqmjsshurudv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Use the VPN gateway ID as the search key.
     */
    @JvmName("nfyygysaaksrxlrs")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpnGatewayId = mapped
    }

    internal fun build(): GetSslVpnServersPlainArgs = GetSslVpnServersPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        vpnGatewayId = vpnGatewayId,
    )
}
