@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetSwitchesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSwitches.
 * @property cidrBlock Filter results by a specific CIDR block. For example: "172.16.0.0/12".
 * @property dryRun Specifies whether to precheck this request only. Valid values: `true` and `false`.
 * @property ids A list of vSwitch IDs.
 * @property isDefault Indicate whether the vSwitch is created by the system.
 * @property nameRegex A regex string to filter results by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The Id of resource group which VSWitch belongs.
 * @property routeTableId The route table ID of the vSwitch.
 * @property status The status of the vSwitch. Valid values: `Available` and `Pending`.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId ID of the VPC that owns the vSwitch.
 * @property vswitchName The name of the vSwitch.
 * @property vswitchOwnerId The vSwitch owner id.
 * @property zoneId The availability zone of the vSwitch.
 */
public data class GetSwitchesPlainArgs(
    public val cidrBlock: String? = null,
    public val dryRun: Boolean? = null,
    public val ids: List<String>? = null,
    public val isDefault: Boolean? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val routeTableId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
    public val vswitchName: String? = null,
    public val vswitchOwnerId: Int? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetSwitchesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetSwitchesPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetSwitchesPlainArgs.builder()
            .cidrBlock(cidrBlock?.let({ args0 -> args0 }))
            .dryRun(dryRun?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .isDefault(isDefault?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .routeTableId(routeTableId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 }))
            .vswitchName(vswitchName?.let({ args0 -> args0 }))
            .vswitchOwnerId(vswitchOwnerId?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSwitchesPlainArgs].
 */
@PulumiTagMarker
public class GetSwitchesPlainArgsBuilder internal constructor() {
    private var cidrBlock: String? = null

    private var dryRun: Boolean? = null

    private var ids: List<String>? = null

    private var isDefault: Boolean? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var routeTableId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    private var vswitchName: String? = null

    private var vswitchOwnerId: Int? = null

    private var zoneId: String? = null

    /**
     * @param value Filter results by a specific CIDR block. For example: "172.16.0.0/12".
     */
    @JvmName("kvpkqjascpbdsqic")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cidrBlock = mapped
    }

    /**
     * @param value Specifies whether to precheck this request only. Valid values: `true` and `false`.
     */
    @JvmName("uewocfhvylbjqmrg")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dryRun = mapped
    }

    /**
     * @param value A list of vSwitch IDs.
     */
    @JvmName("lpetmxwxkvevimor")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of vSwitch IDs.
     */
    @JvmName("obwlhtnbktknqpoo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Indicate whether the vSwitch is created by the system.
     */
    @JvmName("wqiukvglomaqgdcv")
    public suspend fun isDefault(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isDefault = mapped
    }

    /**
     * @param value A regex string to filter results by name.
     */
    @JvmName("igeclshlsdxktnke")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ruqbctfpwptvmxbl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Id of resource group which VSWitch belongs.
     */
    @JvmName("eyvlykewqvcwpoye")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The route table ID of the vSwitch.
     */
    @JvmName("whajjahacoxrvkfx")
    public suspend fun routeTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routeTableId = mapped
    }

    /**
     * @param value The status of the vSwitch. Valid values: `Available` and `Pending`.
     */
    @JvmName("itopqkxyjpdfxekj")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("pgxyskdtexytkogj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("fxqfjxdrhigperhj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value ID of the VPC that owns the vSwitch.
     */
    @JvmName("unlsbserghkcloxo")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    /**
     * @param value The name of the vSwitch.
     */
    @JvmName("jmxvbtbpykwfebpq")
    public suspend fun vswitchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchName = mapped
    }

    /**
     * @param value The vSwitch owner id.
     */
    @JvmName("xndyjehmumfiqewj")
    public suspend fun vswitchOwnerId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchOwnerId = mapped
    }

    /**
     * @param value The availability zone of the vSwitch.
     */
    @JvmName("yfkscujnsyqcdmsj")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetSwitchesPlainArgs = GetSwitchesPlainArgs(
        cidrBlock = cidrBlock,
        dryRun = dryRun,
        ids = ids,
        isDefault = isDefault,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        routeTableId = routeTableId,
        status = status,
        tags = tags,
        vpcId = vpcId,
        vswitchName = vswitchName,
        vswitchOwnerId = vswitchOwnerId,
        zoneId = zoneId,
    )
}
