@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorFilterIngressRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTrafficMirrorFilterIngressRules.
 * @property ids A list of Traffic Mirror Filter Ingress Rule IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
 * @property trafficMirrorFilterId The ID of the Traffic Mirror Filter.
 */
public data class GetTrafficMirrorFilterIngressRulesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val trafficMirrorFilterId: String,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorFilterIngressRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorFilterIngressRulesPlainArgs = com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorFilterIngressRulesPlainArgs.builder()
        .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
        .outputFile(outputFile?.let({ args0 -> args0 }))
        .status(status?.let({ args0 -> args0 }))
        .trafficMirrorFilterId(trafficMirrorFilterId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficMirrorFilterIngressRulesPlainArgs].
 */
@PulumiTagMarker
public class GetTrafficMirrorFilterIngressRulesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var trafficMirrorFilterId: String? = null

    /**
     * @param value A list of Traffic Mirror Filter Ingress Rule IDs.
     */
    @JvmName("dyhjtoibbokearws")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Traffic Mirror Filter Ingress Rule IDs.
     */
    @JvmName("rhmhgclgtoatosek")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("pmifykwyryesqakp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
     */
    @JvmName("csatjgwaywnkdspy")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the Traffic Mirror Filter.
     */
    @JvmName("xoflxpdepomcsabc")
    public suspend fun trafficMirrorFilterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trafficMirrorFilterId = mapped
    }

    internal fun build(): GetTrafficMirrorFilterIngressRulesPlainArgs =
        GetTrafficMirrorFilterIngressRulesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            status = status,
            trafficMirrorFilterId = trafficMirrorFilterId ?: throw
                PulumiNullFieldException("trafficMirrorFilterId"),
        )
}
