@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorFiltersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTrafficMirrorFilters.
 * @property ids A list of Traffic Mirror Filter IDs.
 * @property nameRegex A regex string to filter results by Traffic Mirror Filter name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The state of the filter. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`. `Creating`: The filter is being created. `Created`: The filter is created. `Modifying`: The filter is being modified. `Deleting`: The filter is being deleted.
 * @property trafficMirrorFilterName The name of the filter. The name must be `2` to `128` characters in length, and can contain digits, periods (.), underscores (_), and hyphens (-). It must start with a letter and cannot start with `http://` or `https://`.
 */
public data class GetTrafficMirrorFiltersPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val trafficMirrorFilterName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorFiltersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorFiltersPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorFiltersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .trafficMirrorFilterName(trafficMirrorFilterName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficMirrorFiltersPlainArgs].
 */
@PulumiTagMarker
public class GetTrafficMirrorFiltersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var trafficMirrorFilterName: String? = null

    /**
     * @param value A list of Traffic Mirror Filter IDs.
     */
    @JvmName("kjfueafifxkahsgh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Traffic Mirror Filter IDs.
     */
    @JvmName("sdfqhdgdnbcuvadf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Traffic Mirror Filter name.
     */
    @JvmName("iulnqelbqeacwiru")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hvfptwvqvtqiotdd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The state of the filter. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`. `Creating`: The filter is being created. `Created`: The filter is created. `Modifying`: The filter is being modified. `Deleting`: The filter is being deleted.
     */
    @JvmName("yupiayelkedfpbqa")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The name of the filter. The name must be `2` to `128` characters in length, and can contain digits, periods (.), underscores (_), and hyphens (-). It must start with a letter and cannot start with `http://` or `https://`.
     */
    @JvmName("tckimxytttvdkprd")
    public suspend fun trafficMirrorFilterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.trafficMirrorFilterName = mapped
    }

    internal fun build(): GetTrafficMirrorFiltersPlainArgs = GetTrafficMirrorFiltersPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        trafficMirrorFilterName = trafficMirrorFilterName,
    )
}
