@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTrafficMirrorService.
 * @property enable Setting the value to `On` to enable the service. If has been enabled, return the result. Default value: `Off`. Valid values: `On` and `Off`.
 * > **NOTE:** Setting `enable = "On"` to open the VPC Traffic Mirror service that means you have read and agreed the [VPC Traffic Mirror Terms of Service](https://help.aliyun.com/zh/vpc/support/vpc-terms-of-service). The service can not closed once it is opened.
 */
public data class GetTrafficMirrorServicePlainArgs(
    public val enable: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorServicePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorServicePlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorServicePlainArgs.builder()
            .enable(enable?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficMirrorServicePlainArgs].
 */
@PulumiTagMarker
public class GetTrafficMirrorServicePlainArgsBuilder internal constructor() {
    private var enable: String? = null

    /**
     * @param value Setting the value to `On` to enable the service. If has been enabled, return the result. Default value: `Off`. Valid values: `On` and `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the VPC Traffic Mirror service that means you have read and agreed the [VPC Traffic Mirror Terms of Service](https://help.aliyun.com/zh/vpc/support/vpc-terms-of-service). The service can not closed once it is opened.
     */
    @JvmName("jadvwyqjrfwsgjjr")
    public suspend fun enable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enable = mapped
    }

    internal fun build(): GetTrafficMirrorServicePlainArgs = GetTrafficMirrorServicePlainArgs(
        enable = enable,
    )
}
