@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorSessionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTrafficMirrorSessions.
 * @property enabled Specifies whether to enable traffic mirror sessions. default to `false`.
 * @property ids A list of Traffic Mirror Session IDs.
 * @property nameRegex A regex string to filter results by Traffic Mirror Session name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property priority The priority of the traffic mirror session. Valid values: `1` to `32766`. A smaller value indicates a higher priority. You cannot specify the same priority for traffic mirror sessions that are created in the same region with the same Alibaba Cloud account.
 * @property status The state of the traffic mirror session. Valid values: `Creating`, `Created`, `Modifying` and `Deleting`.
 * @property trafficMirrorFilterId The ID of the filter.
 * @property trafficMirrorSessionName The name of the traffic mirror session. The name must be `2` to `128` characters in length and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
 * @property trafficMirrorSourceId The ID of the mirror source. You can specify only an elastic network interface (ENI) as the mirror source.
 * @property trafficMirrorTargetId The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
 */
public data class GetTrafficMirrorSessionsPlainArgs(
    public val enabled: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val priority: Int? = null,
    public val status: String? = null,
    public val trafficMirrorFilterId: String? = null,
    public val trafficMirrorSessionName: String? = null,
    public val trafficMirrorSourceId: String? = null,
    public val trafficMirrorTargetId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorSessionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorSessionsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetTrafficMirrorSessionsPlainArgs.builder()
            .enabled(enabled?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .priority(priority?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .trafficMirrorFilterId(trafficMirrorFilterId?.let({ args0 -> args0 }))
            .trafficMirrorSessionName(trafficMirrorSessionName?.let({ args0 -> args0 }))
            .trafficMirrorSourceId(trafficMirrorSourceId?.let({ args0 -> args0 }))
            .trafficMirrorTargetId(trafficMirrorTargetId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficMirrorSessionsPlainArgs].
 */
@PulumiTagMarker
public class GetTrafficMirrorSessionsPlainArgsBuilder internal constructor() {
    private var enabled: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var priority: Int? = null

    private var status: String? = null

    private var trafficMirrorFilterId: String? = null

    private var trafficMirrorSessionName: String? = null

    private var trafficMirrorSourceId: String? = null

    private var trafficMirrorTargetId: String? = null

    /**
     * @param value Specifies whether to enable traffic mirror sessions. default to `false`.
     */
    @JvmName("ractincrwircuqpq")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enabled = mapped
    }

    /**
     * @param value A list of Traffic Mirror Session IDs.
     */
    @JvmName("hipbupohuxgtbnqx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Traffic Mirror Session IDs.
     */
    @JvmName("aicsmjtlydhoqykl")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Traffic Mirror Session name.
     */
    @JvmName("nxbwcjfmwenktmdy")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("alrjehghqrjworif")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The priority of the traffic mirror session. Valid values: `1` to `32766`. A smaller value indicates a higher priority. You cannot specify the same priority for traffic mirror sessions that are created in the same region with the same Alibaba Cloud account.
     */
    @JvmName("poymkfniboodrxir")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.priority = mapped
    }

    /**
     * @param value The state of the traffic mirror session. Valid values: `Creating`, `Created`, `Modifying` and `Deleting`.
     */
    @JvmName("tqsxdjpgegnaudwx")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the filter.
     */
    @JvmName("drlpljorxqagflsu")
    public suspend fun trafficMirrorFilterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.trafficMirrorFilterId = mapped
    }

    /**
     * @param value The name of the traffic mirror session. The name must be `2` to `128` characters in length and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
     */
    @JvmName("iirgcbxdmcptdorf")
    public suspend fun trafficMirrorSessionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.trafficMirrorSessionName = mapped
    }

    /**
     * @param value The ID of the mirror source. You can specify only an elastic network interface (ENI) as the mirror source.
     */
    @JvmName("dkkppvowlilmkjil")
    public suspend fun trafficMirrorSourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.trafficMirrorSourceId = mapped
    }

    /**
     * @param value The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
     */
    @JvmName("kyumdurgkalcsqis")
    public suspend fun trafficMirrorTargetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.trafficMirrorTargetId = mapped
    }

    internal fun build(): GetTrafficMirrorSessionsPlainArgs = GetTrafficMirrorSessionsPlainArgs(
        enabled = enabled,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        priority = priority,
        status = status,
        trafficMirrorFilterId = trafficMirrorFilterId,
        trafficMirrorSessionName = trafficMirrorSessionName,
        trafficMirrorSourceId = trafficMirrorSourceId,
        trafficMirrorTargetId = trafficMirrorTargetId,
    )
}
