@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.GetVpcFlowLogsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcFlowLogs.
 * @property description The Description of flow log.
 * @property flowLogName The flow log name.
 * @property ids A list of Flow Log IDs.
 * @property logStoreName The log store name.
 * @property nameRegex A regex string to filter results by Flow Log name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property projectName The project name.
 * @property resourceId The resource id.
 * @property resourceType The resource type. Valid values: `NetworkInterface`, `VPC`, `VSwitch`.
 * @property status The status of  flow log. Valid values: `Active`, `Inactive`.
 * @property trafficType The traffic type. Valid values: `All`, `Allow`, `Drop`.
 */
public data class GetVpcFlowLogsPlainArgs(
    public val description: String? = null,
    public val flowLogName: String? = null,
    public val ids: List<String>? = null,
    public val logStoreName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val projectName: String? = null,
    public val resourceId: String? = null,
    public val resourceType: String? = null,
    public val status: String? = null,
    public val trafficType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.GetVpcFlowLogsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.GetVpcFlowLogsPlainArgs =
        com.pulumi.alicloud.vpc.inputs.GetVpcFlowLogsPlainArgs.builder()
            .description(description?.let({ args0 -> args0 }))
            .flowLogName(flowLogName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .logStoreName(logStoreName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .projectName(projectName?.let({ args0 -> args0 }))
            .resourceId(resourceId?.let({ args0 -> args0 }))
            .resourceType(resourceType?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .trafficType(trafficType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcFlowLogsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcFlowLogsPlainArgsBuilder internal constructor() {
    private var description: String? = null

    private var flowLogName: String? = null

    private var ids: List<String>? = null

    private var logStoreName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var projectName: String? = null

    private var resourceId: String? = null

    private var resourceType: String? = null

    private var status: String? = null

    private var trafficType: String? = null

    /**
     * @param value The Description of flow log.
     */
    @JvmName("rqikojuhbonmioqr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value The flow log name.
     */
    @JvmName("guguvogjyvelwvyh")
    public suspend fun flowLogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.flowLogName = mapped
    }

    /**
     * @param value A list of Flow Log IDs.
     */
    @JvmName("xhgwxwxsfomdtvrp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Flow Log IDs.
     */
    @JvmName("rqtbtvjeriihhipt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The log store name.
     */
    @JvmName("jkomnxhpnsndxhgd")
    public suspend fun logStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.logStoreName = mapped
    }

    /**
     * @param value A regex string to filter results by Flow Log name.
     */
    @JvmName("bgxiurvbyydjshvm")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("niknvtlyovtbsadt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The project name.
     */
    @JvmName("sgtiniwsssucrxjg")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The resource id.
     */
    @JvmName("igyqndxadwgnilet")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    /**
     * @param value The resource type. Valid values: `NetworkInterface`, `VPC`, `VSwitch`.
     */
    @JvmName("pavosmqjeaqqotwu")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    /**
     * @param value The status of  flow log. Valid values: `Active`, `Inactive`.
     */
    @JvmName("lxdydxbbqfqnvuvq")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The traffic type. Valid values: `All`, `Allow`, `Drop`.
     */
    @JvmName("yokvmmrbnwnpbunt")
    public suspend fun trafficType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.trafficType = mapped
    }

    internal fun build(): GetVpcFlowLogsPlainArgs = GetVpcFlowLogsPlainArgs(
        description = description,
        flowLogName = flowLogName,
        ids = ids,
        logStoreName = logStoreName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        projectName = projectName,
        resourceId = resourceId,
        resourceType = resourceType,
        status = status,
        trafficType = trafficType,
    )
}
