@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.NetworkAclAttachmentResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceId The resource id that the network acl will associate with.
 * @property resourceType The resource id that the network acl will associate with. Only support `VSwitch` now.
 */
public data class NetworkAclAttachmentResourceArgs(
    public val resourceId: Output<String>,
    public val resourceType: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.NetworkAclAttachmentResourceArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.NetworkAclAttachmentResourceArgs =
        com.pulumi.alicloud.vpc.inputs.NetworkAclAttachmentResourceArgs.builder()
            .resourceId(resourceId.applyValue({ args0 -> args0 }))
            .resourceType(resourceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclAttachmentResourceArgs].
 */
@PulumiTagMarker
public class NetworkAclAttachmentResourceArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value The resource id that the network acl will associate with.
     */
    @JvmName("fkfoemgeocdmufvy")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The resource id that the network acl will associate with. Only support `VSwitch` now.
     */
    @JvmName("lkspkaayesqsdirw")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The resource id that the network acl will associate with.
     */
    @JvmName("wskuwbsbethesylk")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The resource id that the network acl will associate with. Only support `VSwitch` now.
     */
    @JvmName("ixbchyrwhesbnxde")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): NetworkAclAttachmentResourceArgs = NetworkAclAttachmentResourceArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
    )
}
