@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.NetworkAclEgressAclEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The description of the outbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
 * @property destinationCidrIp The network of the destination address.
 * @property entryType The route entry type. The value can be `custom`, indicating custom.
 * @property ipVersion The IP protocol version of the route entry. Valid values: "IPV4" and "IPV4'.
 * @property networkAclEntryName Name of the outbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
 * @property policy Authorization policy. Value:
 * - accept: Allow.
 * - drop: Refused.
 * @property port The destination port range of the outbound rule.  When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
 * @property protocol The protocol type. Value:
 * - icmp: Network Control Message Protocol.
 * - gre: Generic Routing Encapsulation Protocol.
 * - tcp: Transmission Control Protocol.
 * - udp: User Datagram Protocol.
 * - all: Supports all protocols.
 */
public data class NetworkAclEgressAclEntryArgs(
    public val description: Output<String>? = null,
    public val destinationCidrIp: Output<String>? = null,
    public val entryType: Output<String>? = null,
    public val ipVersion: Output<String>? = null,
    public val networkAclEntryName: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val port: Output<String>? = null,
    public val protocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.NetworkAclEgressAclEntryArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.NetworkAclEgressAclEntryArgs =
        com.pulumi.alicloud.vpc.inputs.NetworkAclEgressAclEntryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationCidrIp(destinationCidrIp?.applyValue({ args0 -> args0 }))
            .entryType(entryType?.applyValue({ args0 -> args0 }))
            .ipVersion(ipVersion?.applyValue({ args0 -> args0 }))
            .networkAclEntryName(networkAclEntryName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclEgressAclEntryArgs].
 */
@PulumiTagMarker
public class NetworkAclEgressAclEntryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationCidrIp: Output<String>? = null

    private var entryType: Output<String>? = null

    private var ipVersion: Output<String>? = null

    private var networkAclEntryName: Output<String>? = null

    private var policy: Output<String>? = null

    private var port: Output<String>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value The description of the outbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
     */
    @JvmName("hgtdluvxlyaxadpj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The network of the destination address.
     */
    @JvmName("jfwexooqtytekfeo")
    public suspend fun destinationCidrIp(`value`: Output<String>) {
        this.destinationCidrIp = value
    }

    /**
     * @param value The route entry type. The value can be `custom`, indicating custom.
     */
    @JvmName("fmtkduqndlcckmbk")
    public suspend fun entryType(`value`: Output<String>) {
        this.entryType = value
    }

    /**
     * @param value The IP protocol version of the route entry. Valid values: "IPV4" and "IPV4'.
     */
    @JvmName("kohrfcmgnuvwrkqn")
    public suspend fun ipVersion(`value`: Output<String>) {
        this.ipVersion = value
    }

    /**
     * @param value Name of the outbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
     */
    @JvmName("knlugbugwxkedlxg")
    public suspend fun networkAclEntryName(`value`: Output<String>) {
        this.networkAclEntryName = value
    }

    /**
     * @param value Authorization policy. Value:
     * - accept: Allow.
     * - drop: Refused.
     */
    @JvmName("oouaknlmormjtiws")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The destination port range of the outbound rule.  When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
     */
    @JvmName("qgbbqvxnarojkskl")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value The protocol type. Value:
     * - icmp: Network Control Message Protocol.
     * - gre: Generic Routing Encapsulation Protocol.
     * - tcp: Transmission Control Protocol.
     * - udp: User Datagram Protocol.
     * - all: Supports all protocols.
     */
    @JvmName("eqyawihdfhffwgty")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The description of the outbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
     */
    @JvmName("bkmqtwtrbnxstfkp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The network of the destination address.
     */
    @JvmName("greevgerpbjalwqb")
    public suspend fun destinationCidrIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidrIp = mapped
    }

    /**
     * @param value The route entry type. The value can be `custom`, indicating custom.
     */
    @JvmName("bthgsmcshbrvchor")
    public suspend fun entryType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entryType = mapped
    }

    /**
     * @param value The IP protocol version of the route entry. Valid values: "IPV4" and "IPV4'.
     */
    @JvmName("lgqkaurqpgrokgie")
    public suspend fun ipVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipVersion = mapped
    }

    /**
     * @param value Name of the outbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
     */
    @JvmName("ieumlcvonvdeqeam")
    public suspend fun networkAclEntryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAclEntryName = mapped
    }

    /**
     * @param value Authorization policy. Value:
     * - accept: Allow.
     * - drop: Refused.
     */
    @JvmName("utnakpnwvjumcwmg")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The destination port range of the outbound rule.  When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
     */
    @JvmName("hapdjppknyxplmbg")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol type. Value:
     * - icmp: Network Control Message Protocol.
     * - gre: Generic Routing Encapsulation Protocol.
     * - tcp: Transmission Control Protocol.
     * - udp: User Datagram Protocol.
     * - all: Supports all protocols.
     */
    @JvmName("fwnpvbyrlaonltdl")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): NetworkAclEgressAclEntryArgs = NetworkAclEgressAclEntryArgs(
        description = description,
        destinationCidrIp = destinationCidrIp,
        entryType = entryType,
        ipVersion = ipVersion,
        networkAclEntryName = networkAclEntryName,
        policy = policy,
        port = port,
        protocol = protocol,
    )
}
