@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.NetworkAclEntriesEgressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description
 * @property destinationCidrIp The destination ip of the egress entry.
 * @property entryType
 * @property name
 * @property policy
 * @property port
 * @property protocol
 */
public data class NetworkAclEntriesEgressArgs(
    public val description: Output<String>? = null,
    public val destinationCidrIp: Output<String>? = null,
    public val entryType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val port: Output<String>? = null,
    public val protocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.NetworkAclEntriesEgressArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.NetworkAclEntriesEgressArgs =
        com.pulumi.alicloud.vpc.inputs.NetworkAclEntriesEgressArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationCidrIp(destinationCidrIp?.applyValue({ args0 -> args0 }))
            .entryType(entryType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclEntriesEgressArgs].
 */
@PulumiTagMarker
public class NetworkAclEntriesEgressArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationCidrIp: Output<String>? = null

    private var entryType: Output<String>? = null

    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    private var port: Output<String>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("mdmdorxblhxvyads")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination ip of the egress entry.
     */
    @JvmName("lytgsohtgonnlyrt")
    public suspend fun destinationCidrIp(`value`: Output<String>) {
        this.destinationCidrIp = value
    }

    /**
     * @param value
     */
    @JvmName("huyxlujcgbkqltta")
    public suspend fun entryType(`value`: Output<String>) {
        this.entryType = value
    }

    /**
     * @param value
     */
    @JvmName("vslntnrreynaxmca")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("radolyvosgmmeogg")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value
     */
    @JvmName("kgavrnjeaclyommm")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("fsxgdyysusoixvwn")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value
     */
    @JvmName("rnpdakcmaojmdelm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination ip of the egress entry.
     */
    @JvmName("ygikivjsvexqxxqt")
    public suspend fun destinationCidrIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidrIp = mapped
    }

    /**
     * @param value
     */
    @JvmName("hstnndxsmynawawx")
    public suspend fun entryType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entryType = mapped
    }

    /**
     * @param value
     */
    @JvmName("riyytplemvayelag")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("kgaosdxrkrctdrfi")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value
     */
    @JvmName("cabwvqxtesdoprlr")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("qmlvjjvktsrajapu")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): NetworkAclEntriesEgressArgs = NetworkAclEntriesEgressArgs(
        description = description,
        destinationCidrIp = destinationCidrIp,
        entryType = entryType,
        name = name,
        policy = policy,
        port = port,
        protocol = protocol,
    )
}
