@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.NetworkAclEntriesIngressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description
 * @property entryType
 * @property name
 * @property policy
 * @property port
 * @property protocol
 * @property sourceCidrIp The source ip of the ingress entry.
 */
public data class NetworkAclEntriesIngressArgs(
    public val description: Output<String>? = null,
    public val entryType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val port: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val sourceCidrIp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.NetworkAclEntriesIngressArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.NetworkAclEntriesIngressArgs =
        com.pulumi.alicloud.vpc.inputs.NetworkAclEntriesIngressArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .entryType(entryType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .sourceCidrIp(sourceCidrIp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclEntriesIngressArgs].
 */
@PulumiTagMarker
public class NetworkAclEntriesIngressArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var entryType: Output<String>? = null

    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    private var port: Output<String>? = null

    private var protocol: Output<String>? = null

    private var sourceCidrIp: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ydgdqcourknmewmc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("tevkfnvvxrwmwbhb")
    public suspend fun entryType(`value`: Output<String>) {
        this.entryType = value
    }

    /**
     * @param value
     */
    @JvmName("ncngcpucophduikd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("njhjypfkiphsgilt")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value
     */
    @JvmName("eapglgdmmncyemmv")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("mtvpsblafoloqesp")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The source ip of the ingress entry.
     */
    @JvmName("vvtqvrrgrdvrieur")
    public suspend fun sourceCidrIp(`value`: Output<String>) {
        this.sourceCidrIp = value
    }

    /**
     * @param value
     */
    @JvmName("ocbkhnjokwccygnv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("aiugwhrcqgxwlrvj")
    public suspend fun entryType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entryType = mapped
    }

    /**
     * @param value
     */
    @JvmName("xerjrjfobaouumbt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("obrijdssrdcfhfvy")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value
     */
    @JvmName("xloqxoicbbmmedti")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("rxyhsowvidayflwc")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The source ip of the ingress entry.
     */
    @JvmName("bxstuksjhflqxdhe")
    public suspend fun sourceCidrIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCidrIp = mapped
    }

    internal fun build(): NetworkAclEntriesIngressArgs = NetworkAclEntriesIngressArgs(
        description = description,
        entryType = entryType,
        name = name,
        policy = policy,
        port = port,
        protocol = protocol,
        sourceCidrIp = sourceCidrIp,
    )
}
