@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.NetworkAclIngressAclEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description Description of the inbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
 * @property entryType The route entry type. The value can be `custom`, indicating custom.
 * @property ipVersion The IP protocol version of the route entry. Valid values: "IPV4" and "IPV6'.
 * @property networkAclEntryName The name of the inbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
 * @property policy Authorization policy. Value:
 * - accept: Allow.
 * - drop: Refused.
 * @property port The source port range of the inbound rule.  When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
 * @property protocol The protocol type. Value:
 * - icmp: Network Control Message Protocol.
 * - gre: Generic Routing Encapsulation Protocol.
 * - tcp: Transmission Control Protocol.
 * - udp: User Datagram Protocol.
 * - all: Supports all protocols.
 * @property sourceCidrIp Source address network segment.
 */
public data class NetworkAclIngressAclEntryArgs(
    public val description: Output<String>? = null,
    public val entryType: Output<String>? = null,
    public val ipVersion: Output<String>? = null,
    public val networkAclEntryName: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val port: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val sourceCidrIp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.NetworkAclIngressAclEntryArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.NetworkAclIngressAclEntryArgs =
        com.pulumi.alicloud.vpc.inputs.NetworkAclIngressAclEntryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .entryType(entryType?.applyValue({ args0 -> args0 }))
            .ipVersion(ipVersion?.applyValue({ args0 -> args0 }))
            .networkAclEntryName(networkAclEntryName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .sourceCidrIp(sourceCidrIp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclIngressAclEntryArgs].
 */
@PulumiTagMarker
public class NetworkAclIngressAclEntryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var entryType: Output<String>? = null

    private var ipVersion: Output<String>? = null

    private var networkAclEntryName: Output<String>? = null

    private var policy: Output<String>? = null

    private var port: Output<String>? = null

    private var protocol: Output<String>? = null

    private var sourceCidrIp: Output<String>? = null

    /**
     * @param value Description of the inbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
     */
    @JvmName("nmxcgllgpbeqdpkl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The route entry type. The value can be `custom`, indicating custom.
     */
    @JvmName("dlmhaioeiuffquhe")
    public suspend fun entryType(`value`: Output<String>) {
        this.entryType = value
    }

    /**
     * @param value The IP protocol version of the route entry. Valid values: "IPV4" and "IPV6'.
     */
    @JvmName("suxqsqahvlnryyrs")
    public suspend fun ipVersion(`value`: Output<String>) {
        this.ipVersion = value
    }

    /**
     * @param value The name of the inbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
     */
    @JvmName("htapjmcjentsabyj")
    public suspend fun networkAclEntryName(`value`: Output<String>) {
        this.networkAclEntryName = value
    }

    /**
     * @param value Authorization policy. Value:
     * - accept: Allow.
     * - drop: Refused.
     */
    @JvmName("hiqklxsoxbpqgqlv")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The source port range of the inbound rule.  When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
     */
    @JvmName("elfjajjuxexorfxn")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value The protocol type. Value:
     * - icmp: Network Control Message Protocol.
     * - gre: Generic Routing Encapsulation Protocol.
     * - tcp: Transmission Control Protocol.
     * - udp: User Datagram Protocol.
     * - all: Supports all protocols.
     */
    @JvmName("wjjbquyckbmhwtjk")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Source address network segment.
     */
    @JvmName("drgqsyjehorewxfr")
    public suspend fun sourceCidrIp(`value`: Output<String>) {
        this.sourceCidrIp = value
    }

    /**
     * @param value Description of the inbound rule.  The description must be 1 to 256 characters in length and cannot start with http:// or https.
     */
    @JvmName("rwluxnivbymqiejf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The route entry type. The value can be `custom`, indicating custom.
     */
    @JvmName("cgtwpwkjufgbgaow")
    public suspend fun entryType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entryType = mapped
    }

    /**
     * @param value The IP protocol version of the route entry. Valid values: "IPV4" and "IPV6'.
     */
    @JvmName("imehhunvegiwqvxk")
    public suspend fun ipVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipVersion = mapped
    }

    /**
     * @param value The name of the inbound rule entry.  The name must be 1 to 128 characters in length and cannot start with http:// or https.
     */
    @JvmName("mdpdsskiljsjlnvf")
    public suspend fun networkAclEntryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAclEntryName = mapped
    }

    /**
     * @param value Authorization policy. Value:
     * - accept: Allow.
     * - drop: Refused.
     */
    @JvmName("ctckilwlgxecynee")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The source port range of the inbound rule.  When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted. When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
     */
    @JvmName("aecsjefqfaxmwywo")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol type. Value:
     * - icmp: Network Control Message Protocol.
     * - gre: Generic Routing Encapsulation Protocol.
     * - tcp: Transmission Control Protocol.
     * - udp: User Datagram Protocol.
     * - all: Supports all protocols.
     */
    @JvmName("foadnxoppycrsfau")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Source address network segment.
     */
    @JvmName("xtddrfaifdprjtyi")
    public suspend fun sourceCidrIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCidrIp = mapped
    }

    internal fun build(): NetworkAclIngressAclEntryArgs = NetworkAclIngressAclEntryArgs(
        description = description,
        entryType = entryType,
        ipVersion = ipVersion,
        networkAclEntryName = networkAclEntryName,
        policy = policy,
        port = port,
        protocol = protocol,
        sourceCidrIp = sourceCidrIp,
    )
}
