@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.NetworkAclResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceId The ID of the associated resource.
 * @property resourceType The type of the associated resource.
 * @property status The state of the network ACL.
 */
public data class NetworkAclResourceArgs(
    public val resourceId: Output<String>,
    public val resourceType: Output<String>,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.NetworkAclResourceArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.NetworkAclResourceArgs =
        com.pulumi.alicloud.vpc.inputs.NetworkAclResourceArgs.builder()
            .resourceId(resourceId.applyValue({ args0 -> args0 }))
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclResourceArgs].
 */
@PulumiTagMarker
public class NetworkAclResourceArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The ID of the associated resource.
     */
    @JvmName("ykfftkagomavodtw")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The type of the associated resource.
     */
    @JvmName("brrndecsbgdqypox")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The state of the network ACL.
     */
    @JvmName("djmciqvoaxvppydn")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The ID of the associated resource.
     */
    @JvmName("oljbiabngmuwctgj")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The type of the associated resource.
     */
    @JvmName("duvxwugvqoflxtrm")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The state of the network ACL.
     */
    @JvmName("ppxyquqbflhojquk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): NetworkAclResourceArgs = NetworkAclResourceArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        status = status,
    )
}
