@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.PrefixListEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidr The CIDR address block of the prefix list.
 * @property description The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
 */
public data class PrefixListEntryArgs(
    public val cidr: Output<String>? = null,
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.PrefixListEntryArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.PrefixListEntryArgs =
        com.pulumi.alicloud.vpc.inputs.PrefixListEntryArgs.builder()
            .cidr(cidr?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrefixListEntryArgs].
 */
@PulumiTagMarker
public class PrefixListEntryArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    private var description: Output<String>? = null

    /**
     * @param value The CIDR address block of the prefix list.
     */
    @JvmName("njihsejvafrhxqxg")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    @JvmName("mykolkloshssmypb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The CIDR address block of the prefix list.
     */
    @JvmName("kewlbcsdvornpupf")
    public suspend fun cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    /**
     * @param value The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    @JvmName("mhvsludqyrwcbpev")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): PrefixListEntryArgs = PrefixListEntryArgs(
        cidr = cidr,
        description = description,
    )
}
