@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.inputs

import com.pulumi.alicloud.vpc.inputs.TrafficMirrorFilterEgressRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action
 * @property destinationCidrBlock
 * @property destinationPortRange
 * @property priority
 * @property protocol
 * @property sourceCidrBlock
 * @property sourcePortRange
 * @property trafficMirrorFilterRuleStatus
 */
public data class TrafficMirrorFilterEgressRuleArgs(
    public val action: Output<String>,
    public val destinationCidrBlock: Output<String>? = null,
    public val destinationPortRange: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val protocol: Output<String>,
    public val sourceCidrBlock: Output<String>? = null,
    public val sourcePortRange: Output<String>? = null,
    public val trafficMirrorFilterRuleStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.inputs.TrafficMirrorFilterEgressRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.inputs.TrafficMirrorFilterEgressRuleArgs =
        com.pulumi.alicloud.vpc.inputs.TrafficMirrorFilterEgressRuleArgs.builder()
            .action(action.applyValue({ args0 -> args0 }))
            .destinationCidrBlock(destinationCidrBlock?.applyValue({ args0 -> args0 }))
            .destinationPortRange(destinationPortRange?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .sourceCidrBlock(sourceCidrBlock?.applyValue({ args0 -> args0 }))
            .sourcePortRange(sourcePortRange?.applyValue({ args0 -> args0 }))
            .trafficMirrorFilterRuleStatus(
                trafficMirrorFilterRuleStatus?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [TrafficMirrorFilterEgressRuleArgs].
 */
@PulumiTagMarker
public class TrafficMirrorFilterEgressRuleArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var destinationCidrBlock: Output<String>? = null

    private var destinationPortRange: Output<String>? = null

    private var priority: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var sourceCidrBlock: Output<String>? = null

    private var sourcePortRange: Output<String>? = null

    private var trafficMirrorFilterRuleStatus: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("knajobiyikwpgxmd")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value
     */
    @JvmName("nhpwfyxpaanoqxyi")
    public suspend fun destinationCidrBlock(`value`: Output<String>) {
        this.destinationCidrBlock = value
    }

    /**
     * @param value
     */
    @JvmName("jcobnllncvgmnkae")
    public suspend fun destinationPortRange(`value`: Output<String>) {
        this.destinationPortRange = value
    }

    /**
     * @param value
     */
    @JvmName("hvdbgjrlwigfbdfd")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value
     */
    @JvmName("ydjnskodopxglfpi")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value
     */
    @JvmName("lhpouycmslxvfspl")
    public suspend fun sourceCidrBlock(`value`: Output<String>) {
        this.sourceCidrBlock = value
    }

    /**
     * @param value
     */
    @JvmName("bofedjmhhbaficmn")
    public suspend fun sourcePortRange(`value`: Output<String>) {
        this.sourcePortRange = value
    }

    /**
     * @param value
     */
    @JvmName("bqvigsmnthsgyduc")
    public suspend fun trafficMirrorFilterRuleStatus(`value`: Output<String>) {
        this.trafficMirrorFilterRuleStatus = value
    }

    /**
     * @param value
     */
    @JvmName("lnxjxnjkrxqsojvk")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value
     */
    @JvmName("sjhjmyrfrpiesbkm")
    public suspend fun destinationCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidrBlock = mapped
    }

    /**
     * @param value
     */
    @JvmName("srgrxuidvmimvihv")
    public suspend fun destinationPortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRange = mapped
    }

    /**
     * @param value
     */
    @JvmName("btmtgaoilqrrsitx")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value
     */
    @JvmName("liyujjgsrhlekavy")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value
     */
    @JvmName("hvbucrfqgnfwiyia")
    public suspend fun sourceCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCidrBlock = mapped
    }

    /**
     * @param value
     */
    @JvmName("xxsaxcvokvqchokv")
    public suspend fun sourcePortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRange = mapped
    }

    /**
     * @param value
     */
    @JvmName("rlhhubkxsohrtxwf")
    public suspend fun trafficMirrorFilterRuleStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficMirrorFilterRuleStatus = mapped
    }

    internal fun build(): TrafficMirrorFilterEgressRuleArgs = TrafficMirrorFilterEgressRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        destinationCidrBlock = destinationCidrBlock,
        destinationPortRange = destinationPortRange,
        priority = priority,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        sourceCidrBlock = sourceCidrBlock,
        sourcePortRange = sourcePortRange,
        trafficMirrorFilterRuleStatus = trafficMirrorFilterRuleStatus,
    )
}
