@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property associateStatus The status of the VPC associated with the DHCP option set.
 * @property vpcId The ID of the VPC network that is associated with the DHCP options set.
 */
public data class DhcpOptionsSetAssociateVpc(
    public val associateStatus: String? = null,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.DhcpOptionsSetAssociateVpc): DhcpOptionsSetAssociateVpc = DhcpOptionsSetAssociateVpc(
            associateStatus = javaType.associateStatus().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId(),
        )
    }
}
