@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authKey The key used by the BGP group.
 * @property bgpGroupName The name of the BGP group.
 * @property description Description of the BGP group.
 * @property hold The hold time to wait for the incoming BGP message. If no message has been passed in after the hold time, the BGP neighbor is considered disconnected.
 * @property id The ID of the Bgp Group.
 * @property ipVersion IP version.
 * @property isFakeAsn Whether the AS number is false.
 * @property keepalive The keepalive time.
 * @property localAsn The local AS number.
 * @property peerAsn The autonomous system (AS) number of the BGP peer.
 * @property routeLimit Routing limits.
 * @property routerId The ID of the VBR.
 * @property status The status of the resource.
 */
public data class GetBgpGroupsGroup(
    public val authKey: String,
    public val bgpGroupName: String,
    public val description: String,
    public val hold: String,
    public val id: String,
    public val ipVersion: String,
    public val isFakeAsn: Boolean,
    public val keepalive: String,
    public val localAsn: Int,
    public val peerAsn: Int,
    public val routeLimit: String,
    public val routerId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetBgpGroupsGroup): GetBgpGroupsGroup = GetBgpGroupsGroup(
            authKey = javaType.authKey(),
            bgpGroupName = javaType.bgpGroupName(),
            description = javaType.description(),
            hold = javaType.hold(),
            id = javaType.id(),
            ipVersion = javaType.ipVersion(),
            isFakeAsn = javaType.isFakeAsn(),
            keepalive = javaType.keepalive(),
            localAsn = javaType.localAsn(),
            peerAsn = javaType.peerAsn(),
            routeLimit = javaType.routeLimit(),
            routerId = javaType.routerId(),
            status = javaType.status(),
        )
    }
}
