@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dstCidrBlock Advertised BGP networks.
 * @property id The ID of the Bgp Network. The value formats as `<router_id>:<dst_cidr_block>`.
 * @property routerId The ID of the vRouter.
 * @property status The state of the advertised BGP network.
 */
public data class GetBgpNetworksNetwork(
    public val dstCidrBlock: String,
    public val id: String,
    public val routerId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetBgpNetworksNetwork): GetBgpNetworksNetwork = GetBgpNetworksNetwork(
            dstCidrBlock = javaType.dstCidrBlock(),
            id = javaType.id(),
            routerId = javaType.routerId(),
            status = javaType.status(),
        )
    }
}
