@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBgpNetworks.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property networks
 * @property outputFile
 * @property routerId
 * @property status
 */
public data class GetBgpNetworksResult(
    public val id: String,
    public val ids: List<String>,
    public val networks: List<GetBgpNetworksNetwork>,
    public val outputFile: String? = null,
    public val routerId: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetBgpNetworksResult): GetBgpNetworksResult = GetBgpNetworksResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            networks = javaType.networks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetBgpNetworksNetwork.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            routerId = javaType.routerId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
