@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authKey The authentication key of the BGP group.
 * @property bfdMultiHop The BFD hop count.
 * @property bgpGroupId The ID of the BGP group.
 * @property bgpPeerId The ID of the BGP neighbor.
 * @property bgpPeerName The name of the BGP neighbor.
 * @property bgpStatus The status of the BGP connection.
 * @property description The description of the BGP group.
 * @property enableBfd Indicates whether the Bidirectional Forwarding Detection (BFD) protocol is enabled.
 * @property hold The hold time.
 * @property id The ID of the Bgp Peer.
 * @property ipVersion The IP version.
 * @property isFake Indicates whether a fake AS number is used.
 * @property keepalive The keepalive time.
 * @property localAsn The AS number of the device on the Alibaba Cloud side.
 * @property peerAsn The autonomous system (AS) number of the BGP peer.
 * @property peerIpAddress The IP address of the BGP neighbor.
 * @property routeLimit The limit on routes.
 * @property routerId The ID of the router.
 * @property status The status of the BGP peer.
 */
public data class GetBgpPeersPeer(
    public val authKey: String,
    public val bfdMultiHop: Int,
    public val bgpGroupId: String,
    public val bgpPeerId: String,
    public val bgpPeerName: String,
    public val bgpStatus: String,
    public val description: String,
    public val enableBfd: Boolean,
    public val hold: String,
    public val id: String,
    public val ipVersion: String,
    public val isFake: Boolean,
    public val keepalive: String,
    public val localAsn: String,
    public val peerAsn: String,
    public val peerIpAddress: String,
    public val routeLimit: String,
    public val routerId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetBgpPeersPeer): GetBgpPeersPeer = GetBgpPeersPeer(
            authKey = javaType.authKey(),
            bfdMultiHop = javaType.bfdMultiHop(),
            bgpGroupId = javaType.bgpGroupId(),
            bgpPeerId = javaType.bgpPeerId(),
            bgpPeerName = javaType.bgpPeerName(),
            bgpStatus = javaType.bgpStatus(),
            description = javaType.description(),
            enableBfd = javaType.enableBfd(),
            hold = javaType.hold(),
            id = javaType.id(),
            ipVersion = javaType.ipVersion(),
            isFake = javaType.isFake(),
            keepalive = javaType.keepalive(),
            localAsn = javaType.localAsn(),
            peerAsn = javaType.peerAsn(),
            peerIpAddress = javaType.peerIpAddress(),
            routeLimit = javaType.routeLimit(),
            routerId = javaType.routerId(),
            status = javaType.status(),
        )
    }
}
