@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBgpPeers.
 * @property bgpGroupId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property peers
 * @property routerId
 * @property status
 */
public data class GetBgpPeersResult(
    public val bgpGroupId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val peers: List<GetBgpPeersPeer>,
    public val routerId: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetBgpPeersResult): GetBgpPeersResult = GetBgpPeersResult(
            bgpGroupId = javaType.bgpGroupId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            peers = javaType.peers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetBgpPeersPeer.Companion.toKotlin(args0)
                })
            }),
            routerId = javaType.routerId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
