@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bandwidth The peak bandwidth of the Internet Shared Bandwidth instance.
 * @property bandwidthPackageId The resource ID of bandwidth package.
 * @property bandwidthPackageName The name of bandwidth package.
 * @property businessStatus The business status of the Common Bandwidth Package instance.
 * @property deletionProtection The deletion protection of bandwidth package.
 * @property description The description of the Common Bandwidth Package instance.
 * @property expiredTime The expired time of bandwidth package.
 * @property hasReservationData Is has reservation data.
 * @property id ID of the Common Bandwidth Package.
 * @property internetChargeType The internet charge type of bandwidth package.
 * @property isp ISP of the Common Bandwidth Package.
 * @property name Name of the Common Bandwidth Package.
 * @property paymentType The payment type of bandwidth package.
 * @property publicIpAddresses Public ip addresses that in the Common Bandwidth Pakcage.
 * @property ratio The ratio of bandwidth package.
 * @property reservationActiveTime The active time of reservation.
 * @property reservationBandwidth The bandwidth of reservation.
 * @property reservationInternetChargeType The charge type of reservation internet.
 * @property reservationOrderType The type of reservation order.
 * @property resourceGroupId The Id of resource group which the common bandwidth package belongs.
 * @property serviceManaged The service managed.
 * @property status The status of bandwidth package. Valid values: `Available` and `Pending`.
 */
public data class GetCommonBandwidthPackagesPackage(
    public val bandwidth: String,
    public val bandwidthPackageId: String,
    public val bandwidthPackageName: String,
    public val businessStatus: String,
    public val deletionProtection: Boolean,
    public val description: String,
    public val expiredTime: String,
    public val hasReservationData: Boolean,
    public val id: String,
    public val internetChargeType: String,
    public val isp: String,
    public val name: String,
    public val paymentType: String,
    public val publicIpAddresses: List<GetCommonBandwidthPackagesPackagePublicIpAddress>,
    public val ratio: Int,
    public val reservationActiveTime: String,
    public val reservationBandwidth: String,
    public val reservationInternetChargeType: String,
    public val reservationOrderType: String,
    public val resourceGroupId: String,
    public val serviceManaged: Int,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetCommonBandwidthPackagesPackage): GetCommonBandwidthPackagesPackage = GetCommonBandwidthPackagesPackage(
            bandwidth = javaType.bandwidth(),
            bandwidthPackageId = javaType.bandwidthPackageId(),
            bandwidthPackageName = javaType.bandwidthPackageName(),
            businessStatus = javaType.businessStatus(),
            deletionProtection = javaType.deletionProtection(),
            description = javaType.description(),
            expiredTime = javaType.expiredTime(),
            hasReservationData = javaType.hasReservationData(),
            id = javaType.id(),
            internetChargeType = javaType.internetChargeType(),
            isp = javaType.isp(),
            name = javaType.name(),
            paymentType = javaType.paymentType(),
            publicIpAddresses = javaType.publicIpAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetCommonBandwidthPackagesPackagePublicIpAddress.Companion.toKotlin(args0)
                })
            }),
            ratio = javaType.ratio(),
            reservationActiveTime = javaType.reservationActiveTime(),
            reservationBandwidth = javaType.reservationBandwidth(),
            reservationInternetChargeType = javaType.reservationInternetChargeType(),
            reservationOrderType = javaType.reservationOrderType(),
            resourceGroupId = javaType.resourceGroupId(),
            serviceManaged = javaType.serviceManaged(),
            status = javaType.status(),
        )
    }
}
