@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCommonBandwidthPackages.
 * @property bandwidthPackageName The name of bandwidth package.
 * @property dryRun
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids (Optional) A list of Common Bandwidth Packages IDs.
 * @property includeReservationData
 * @property nameRegex
 * @property names A list of Common Bandwidth Packages names.
 * @property outputFile
 * @property packages A list of Common Bandwidth Packages. Each element contains the following attributes:
 * @property resourceGroupId The Id of resource group which the common bandwidth package belongs.
 * @property status Status of the Common Bandwidth Package.
 */
public data class GetCommonBandwidthPackagesResult(
    public val bandwidthPackageName: String? = null,
    public val dryRun: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val includeReservationData: Boolean? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val packages: List<GetCommonBandwidthPackagesPackage>,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetCommonBandwidthPackagesResult): GetCommonBandwidthPackagesResult = GetCommonBandwidthPackagesResult(
            bandwidthPackageName = javaType.bandwidthPackageName().map({ args0 -> args0 }).orElse(null),
            dryRun = javaType.dryRun().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            includeReservationData = javaType.includeReservationData().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            packages = javaType.packages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetCommonBandwidthPackagesPackage.Companion.toKotlin(args0)
                })
            }),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
