@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDhcpOptionsSets.
 * @property dhcpOptionsSetName
 * @property domainName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property sets
 * @property status
 */
public data class GetDhcpOptionsSetsResult(
    public val dhcpOptionsSetName: String? = null,
    public val domainName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val sets: List<GetDhcpOptionsSetsSet>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetDhcpOptionsSetsResult): GetDhcpOptionsSetsResult = GetDhcpOptionsSetsResult(
            dhcpOptionsSetName = javaType.dhcpOptionsSetName().map({ args0 -> args0 }).orElse(null),
            domainName = javaType.domainName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            sets = javaType.sets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetDhcpOptionsSetsSet.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
