@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property associateVpcCount The Number of VPCs bound by the DHCP option set.
 * @property dhcpOptionsSetDescription The description of the DHCP options set. The description must be 2 to 256
 * characters in length and cannot start with `http://` or `https://`.
 * @property dhcpOptionsSetId
 * @property dhcpOptionsSetName The root domain, for example, example.com. After a DHCP options set is associated with a
 * Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the
 * ECS instances in the VPC network.
 * @property domainName The root domain, for example, example.com. After a DHCP options set is associated with a Virtual
 * Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS
 * instances in the VPC network.
 * @property domainNameServers The DNS server IP addresses. Up to four DNS server IP addresses can be specified. IP
 * addresses must be separated with commas (,).
 * @property id
 * @property ownerId The ID of the account to which the DHCP options set belongs.
 * @property status The status of the DHCP options set. Valid values: `Available`, `InUse` or `Pending`. `Available`: The DHCP options set is available for use. `InUse`: The DHCP options set is in use. `Pending`: The DHCP options set is being configured.
 */
public data class GetDhcpOptionsSetsSet(
    public val associateVpcCount: Int,
    public val dhcpOptionsSetDescription: String,
    public val dhcpOptionsSetId: String,
    public val dhcpOptionsSetName: String,
    public val domainName: String,
    public val domainNameServers: String,
    public val id: String,
    public val ownerId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetDhcpOptionsSetsSet): GetDhcpOptionsSetsSet = GetDhcpOptionsSetsSet(
            associateVpcCount = javaType.associateVpcCount(),
            dhcpOptionsSetDescription = javaType.dhcpOptionsSetDescription(),
            dhcpOptionsSetId = javaType.dhcpOptionsSetId(),
            dhcpOptionsSetName = javaType.dhcpOptionsSetName(),
            domainName = javaType.domainName(),
            domainNameServers = javaType.domainNameServers(),
            id = javaType.id(),
            ownerId = javaType.ownerId(),
            status = javaType.status(),
        )
    }
}
