@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEnhancedNatAvailableZones.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property zones
 */
public data class GetEnhancedNatAvailableZonesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val zones: List<GetEnhancedNatAvailableZonesZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetEnhancedNatAvailableZonesResult): GetEnhancedNatAvailableZonesResult = GetEnhancedNatAvailableZonesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            zones = javaType.zones().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetEnhancedNatAvailableZonesZone.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
