@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property externalIp The public IP address.
 * @property externalPort The public port.
 * @property forwardEntryId The forward entry ID.
 * @property forwardEntryName The name of forward entry.
 * @property id The ID of the Forward Entry.
 * @property internalIp The private IP address.
 * @property internalPort The internal port.
 * @property ipProtocol The ip protocol. Valid values: `any`,`tcp` and `udp`.
 * @property name The forward entry name.
 * @property status The status of farward entry. Valid value `Available`, `Deleting` and `Pending`.
 */
public data class GetForwardEntriesEntry(
    public val externalIp: String,
    public val externalPort: String,
    public val forwardEntryId: String,
    public val forwardEntryName: String,
    public val id: String,
    public val internalIp: String,
    public val internalPort: String,
    public val ipProtocol: String,
    public val name: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetForwardEntriesEntry): GetForwardEntriesEntry = GetForwardEntriesEntry(
            externalIp = javaType.externalIp(),
            externalPort = javaType.externalPort(),
            forwardEntryId = javaType.forwardEntryId(),
            forwardEntryName = javaType.forwardEntryName(),
            id = javaType.id(),
            internalIp = javaType.internalIp(),
            internalPort = javaType.internalPort(),
            ipProtocol = javaType.ipProtocol(),
            name = javaType.name(),
            status = javaType.status(),
        )
    }
}
