@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getForwardEntries.
 * @property entries A list of Forward Entries. Each element contains the following attributes:
 * @property externalIp The public IP address.
 * @property externalPort The public port.
 * @property forwardEntryName The name of forward entry.
 * @property forwardTableId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Forward Entries IDs.
 * @property internalIp The private IP address.
 * @property internalPort The private port.
 * @property ipProtocol The protocol type.
 * @property nameRegex
 * @property names A list of Forward Entries names.
 * @property outputFile
 * @property status The status of forward entry.
 */
public data class GetForwardEntriesResult(
    public val entries: List<GetForwardEntriesEntry>,
    public val externalIp: String? = null,
    public val externalPort: String? = null,
    public val forwardEntryName: String? = null,
    public val forwardTableId: String,
    public val id: String,
    public val ids: List<String>,
    public val internalIp: String? = null,
    public val internalPort: String? = null,
    public val ipProtocol: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetForwardEntriesResult): GetForwardEntriesResult = GetForwardEntriesResult(
            entries = javaType.entries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetForwardEntriesEntry.Companion.toKotlin(args0)
                })
            }),
            externalIp = javaType.externalIp().map({ args0 -> args0 }).orElse(null),
            externalPort = javaType.externalPort().map({ args0 -> args0 }).orElse(null),
            forwardEntryName = javaType.forwardEntryName().map({ args0 -> args0 }).orElse(null),
            forwardTableId = javaType.forwardTableId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            internalIp = javaType.internalIp().map({ args0 -> args0 }).orElse(null),
            internalPort = javaType.internalPort().map({ args0 -> args0 }).orElse(null),
            ipProtocol = javaType.ipProtocol().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
