@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property associatedEipAddresses EIP bound to HaVip.
 * @property associatedInstances An ECS instance that is bound to HaVip.
 * @property description Dependence of a HaVip instance.
 * @property havipId The  ID of the resource.
 * @property havipName The name of the HaVip instance.
 * @property id The ID of the Ha Vip.
 * @property ipAddress IP address of private network.
 * @property masterInstanceId The primary instance ID bound to HaVip.
 * @property status The status.
 * @property vpcId The VPC ID to which the HaVip instance belongs.
 * @property vswitchId The vswitch id.
 */
public data class GetHavipsHavip(
    public val associatedEipAddresses: List<String>,
    public val associatedInstances: List<String>,
    public val description: String,
    public val havipId: String,
    public val havipName: String,
    public val id: String,
    public val ipAddress: String,
    public val masterInstanceId: String,
    public val status: String,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetHavipsHavip): GetHavipsHavip =
            GetHavipsHavip(
                associatedEipAddresses = javaType.associatedEipAddresses().map({ args0 -> args0 }),
                associatedInstances = javaType.associatedInstances().map({ args0 -> args0 }),
                description = javaType.description(),
                havipId = javaType.havipId(),
                havipName = javaType.havipName(),
                id = javaType.id(),
                ipAddress = javaType.ipAddress(),
                masterInstanceId = javaType.masterInstanceId(),
                status = javaType.status(),
                vpcId = javaType.vpcId(),
                vswitchId = javaType.vswitchId(),
            )
    }
}
